import { AdministrativeDivision, Country } from "src/framework/domain";
import { Subdivision } from "src/framework/domain/entities/subdivision.entity";
export interface GeoRepository {
    findCountries(): Promise<Country[]>;
    findCountryById(id: number): Promise<Country | null>;
    getAllSubdivisions(): Promise<Subdivision[]>;
    getAllAdministrativeDivisions(): Promise<AdministrativeDivision[]>;
    findSubdivisionsByCountryCode(countryCode: string): Promise<Subdivision[]>;
    findAdmdivisionsBySubdivisionCode(subdivisionCode: number): Promise<AdministrativeDivision[]>;
    findAdmdivisionsByCountry(prefixCode: string): Promise<AdministrativeDivision[]>;
}
