import { InsertUserRequest, ProgramUserRequestTO, RequestTenderTO, UserRequest } from 'src/framework';
import { TenderTO } from 'src/licitaapp/domain';
export interface UserRequestService {
    createProgramUserRequest(userId: number, dataUserRequest: ProgramUserRequestTO): Promise<String>;
    createUserRequest(userId: number, dataUserRequest: InsertUserRequest): Promise<UserRequest | null>;
    getPagination(page: number, pageSize: number, filter: string, shortStateUserRequest: string): Promise<RequestTenderTO[]>;
    deleteLogicalRemove(userRequestId: number): Promise<void>;
    updateUserStateOrLogicalRemove(userRequestId: number, stateRequestType: string): Promise<UserRequest | null>;
    countActiveUserRequests(): Promise<number>;
    erraseUserRequests(tenderIds: TenderTO[]): Promise<void>;
}
