"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateStateUserRequest = exports.UpdateUserRequest = exports.UserRequest = exports.InsertUserRequest = void 0;
const swagger_1 = require("@nestjs/swagger");
class UserRequest {
    constructor(id, companyId, stateRequestTypeId, title, tenderId, description, userId, createdAt, updatedAt, shortStateUserRequest, dafaultTextStateUserRequest) {
        this.id = id;
        this.companyId = companyId;
        this.stateRequestTypeId = stateRequestTypeId;
        this.userId = userId;
        this.tenderId = tenderId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.title = title;
        this.description = description;
        this.shortStateUserRequest = shortStateUserRequest;
        this.dafaultTextStateUserRequest = dafaultTextStateUserRequest;
    }
}
exports.UserRequest = UserRequest;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'UserRequest id',
        example: 1,
    }),
    __metadata("design:type", Number)
], UserRequest.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Company id',
        example: 1,
        required: true,
    }),
    __metadata("design:type", Number)
], UserRequest.prototype, "companyId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'titulo de la solicitud',
        example: 'title',
        type: String,
        required: true,
    }),
    __metadata("design:type", String)
], UserRequest.prototype, "title", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'description of the request',
        example: 'description',
        type: String,
        required: false,
    }),
    __metadata("design:type", String)
], UserRequest.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender id',
        example: 1,
        type: Number,
        required: true,
    }),
    __metadata("design:type", Object)
], UserRequest.prototype, "tenderId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'User id',
        example: 1,
        required: false,
    }),
    __metadata("design:type", Number)
], UserRequest.prototype, "userId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'State request type id',
        example: 1,
        required: true,
    }),
    __metadata("design:type", Number)
], UserRequest.prototype, "stateRequestTypeId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Creation date',
        example: '1991-01-01T00:00:00.000Z',
        type: Date,
        required: false,
    }),
    __metadata("design:type", Object)
], UserRequest.prototype, "createdAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Last update date',
        example: '1991-01-01T00:00:00.000Z',
        type: Date,
        required: false,
    }),
    __metadata("design:type", Object)
], UserRequest.prototype, "updatedAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'short display template',
        example: 'tutorial.template.first',
        required: false,
    }),
    __metadata("design:type", String)
], UserRequest.prototype, "shortStateUserRequest", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'short default text template',
        example: 'Solicitado',
        required: false,
    }),
    __metadata("design:type", String)
], UserRequest.prototype, "dafaultTextStateUserRequest", void 0);
class InsertUserRequest extends (0, swagger_1.OmitType)(UserRequest, [
    'id',
    'userId',
    'createdAt',
    'updatedAt',
    'shortStateUserRequest',
    'dafaultTextStateUserRequest',
]) {
}
exports.InsertUserRequest = InsertUserRequest;
class UpdateStateUserRequest extends (0, swagger_1.OmitType)(UserRequest, [
    'companyId',
    'title',
    'description',
    'tenderId',
    'stateRequestTypeId',
    'userId',
    'createdAt',
    'updatedAt',
    'dafaultTextStateUserRequest',
]) {
}
exports.UpdateStateUserRequest = UpdateStateUserRequest;
class UpdateUserRequest extends (0, swagger_1.PartialType)(UserRequest) {
}
exports.UpdateUserRequest = UpdateUserRequest;
//# sourceMappingURL=user-request.entity.js.map