import { UserRoleService, UserService } from 'src/framework/application';
import { LoginOutTO, RecordOutTO, RecordTO, User } from 'src/framework/domain';
import { DecodedIdToken } from 'firebase-admin/lib/auth/token-verifier';
import { ConfigService } from '@nestjs/config';
export declare class AccessController {
    private readonly userService;
    private readonly userRoleService;
    private readonly configService;
    private readonly LOGGER;
    private readonly latestVersionAndroid;
    private readonly latestVersionIOS;
    constructor(userService: UserService, userRoleService: UserRoleService, configService: ConfigService);
    erraseAccount(user: User): Promise<String>;
    recordUserForm(decodedToken: DecodedIdToken, recordTO: RecordTO): Promise<RecordOutTO>;
    checkStatusSession(user: User, accessToken: string): Promise<LoginOutTO | undefined>;
    me(user: User): Promise<User>;
    unsubscribe(user: User): Promise<String>;
}
