import { EmailService, User, UserDeviceService, FirebaseService } from 'src/framework';
import { NotificationRecordService } from 'src/framework/application/service/notification-record-service/notification-record-service.interface';
import { InsertUserDevice } from 'src/framework/domain/entities/user-device.entity';
import { TestEmailTo } from 'src/framework/domain/dto/test-email.to';
import { TestNotificationTo } from 'src/framework/domain/dto/test-notification.to';
import { NotificationRecord } from 'src/framework/domain/entities/notification-record.entity';
export declare class NotificationController {
    private readonly emailService;
    private readonly userDeviceService;
    private readonly firebaseService;
    private readonly notificationRecordService;
    private readonly LOGGER;
    constructor(emailService: EmailService, userDeviceService: UserDeviceService, firebaseService: FirebaseService, notificationRecordService: NotificationRecordService);
    getNotificationRecordsPaginated(user: User, page: number, pageSize: number): Promise<NotificationRecord[]>;
    saveDeviceToken(user: User, deviceInfo: InsertUserDevice): Promise<string>;
    testEmail(emailParams: TestEmailTo): Promise<void>;
    testNotification(params: TestNotificationTo): Promise<void>;
}
