"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var UserCampaignsController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserCampaignsController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const definition_1 = require("../../definition");
const api_default_responses_decorator_1 = require("../../decorators/api-default-responses/api-default-responses.decorator");
const allow_roles_decorator_1 = require("../../decorators/allow-profiles/allow-roles.decorator");
const decorators_1 = require("../../decorators");
const domain_1 = require("../../../domain");
let UserCampaignsController = UserCampaignsController_1 = class UserCampaignsController {
    constructor(userCampaignsService) {
        this.userCampaignsService = userCampaignsService;
        this.LOGGER = new definition_1.PrimeLogger(UserCampaignsController_1.name);
    }
    async save(data) {
        this.LOGGER.log('save user campaign data: ' + JSON.stringify(data));
        return await this.userCampaignsService.create(data);
    }
    async updateUserCampaign(data) {
        this.LOGGER.log(`update user campaign data: ${JSON.stringify(data)}`);
        return await this.userCampaignsService.update(data);
    }
    async getPaginatedUserCampaign(page, pageSize, filter) {
        this.LOGGER.log(`getPaginatedUserCampaign - page: ${page}, pageSize: ${pageSize}, filter: ${filter}`);
        return await this.userCampaignsService.getPagination(page, pageSize, filter);
    }
    async logicalRemove(campaignId) {
        this.LOGGER.log(`logicalRemove user ${campaignId}`);
        await this.userCampaignsService.logicalRemove(campaignId);
        this.LOGGER.log(`logicalRemove user ${campaignId} deleted`);
        return 'true';
    }
};
exports.UserCampaignsController = UserCampaignsController;
__decorate([
    (0, common_1.Post)(),
    (0, decorators_1.ApiVehicleResponses)(),
    (0, swagger_1.ApiConflictResponse)({ type: definition_1.ApiErrorExamples }),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER),
    (0, swagger_1.ApiOkResponse)({ type: domain_1.UserCampaign }),
    (0, swagger_1.ApiBody)({ type: domain_1.InsertUserCampaign }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.InsertUserCampaign]),
    __metadata("design:returntype", Promise)
], UserCampaignsController.prototype, "save", null);
__decorate([
    (0, common_1.Put)(),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiConflictResponse)({ type: definition_1.ApiErrorResponse }),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.UpdateUserCampaign]),
    __metadata("design:returntype", Promise)
], UserCampaignsController.prototype, "updateUserCampaign", null);
__decorate([
    (0, common_1.Get)(':page/:pageSize'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER),
    (0, swagger_1.ApiOkResponse)({ type: [domain_1.UserCampaign] }),
    (0, swagger_1.ApiParam)({ name: 'page', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'pageSize', type: 'number' }),
    (0, swagger_1.ApiQuery)({ name: 'filter', required: false, type: String, description: 'Filtro opcional para titulos' }),
    __param(0, (0, common_1.Param)('page')),
    __param(1, (0, common_1.Param)('pageSize')),
    __param(2, (0, common_1.Query)('filter')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String]),
    __metadata("design:returntype", Promise)
], UserCampaignsController.prototype, "getPaginatedUserCampaign", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiConflictResponse)({ type: definition_1.ApiErrorResponse }),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    (0, swagger_1.ApiParam)({ name: 'id', type: 'number' }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], UserCampaignsController.prototype, "logicalRemove", null);
exports.UserCampaignsController = UserCampaignsController = UserCampaignsController_1 = __decorate([
    (0, swagger_1.ApiTags)('user-campaigns'),
    (0, common_1.Controller)('user-campaigns'),
    __param(0, (0, common_1.Inject)('UserCampaignsService')),
    __metadata("design:paramtypes", [Object])
], UserCampaignsController);
//# sourceMappingURL=user-campaigns.controller.js.map