"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var UserRequestController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserRequestController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const definition_1 = require("../../definition");
const api_default_responses_decorator_1 = require("../../decorators/api-default-responses/api-default-responses.decorator");
const domain_1 = require("../../../domain");
const prime_user_decorator_1 = require("../../decorators/prime-user/prime-user.decorator");
const util_1 = require("util");
let UserRequestController = UserRequestController_1 = class UserRequestController {
    constructor(userRequestService) {
        this.userRequestService = userRequestService;
        this.LOGGER = new definition_1.PrimeLogger(UserRequestController_1.name);
    }
    async createUserRequest(user, dataUserRequest) {
        this.LOGGER.log(`Creating user request for user: ${user.id}`);
        return await this.userRequestService.createUserRequest(user.id, dataUserRequest);
    }
    async createProgramUserRequest(user, dataUserRequest) {
        this.LOGGER.log(`Creating user request for user: ${user.id} ${(0, util_1.inspect)(domain_1.ProgramUserRequestTO)}`);
        return await this.userRequestService.createProgramUserRequest(user.id, dataUserRequest);
    }
    async getPaginatedUserRequest(page, pageSize, filter, shortStateUserRequest) {
        this.LOGGER.log(`GetPaginatedUserRequest - page: ${page}, pageSize: ${pageSize}, filter: ${filter}, shortStateUserRequest: ${shortStateUserRequest}`);
        return await this.userRequestService.getPagination(page, pageSize, filter, shortStateUserRequest);
    }
    async update(body) {
        this.LOGGER.log(`Updating UserStateOrLogicalRemove request: ${(0, util_1.inspect)(body)}`);
        await this.userRequestService.updateUserStateOrLogicalRemove(body.id, `state.request.type.${body.shortStateUserRequest}`);
        return 'true';
    }
};
exports.UserRequestController = UserRequestController;
__decorate([
    (0, common_1.Post)(),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: domain_1.UserRequest }),
    (0, swagger_1.ApiBody)({ type: domain_1.InsertUserRequest }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.User,
        domain_1.InsertUserRequest]),
    __metadata("design:returntype", Promise)
], UserRequestController.prototype, "createUserRequest", null);
__decorate([
    (0, common_1.Post)('program'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    (0, swagger_1.ApiBody)({ type: domain_1.ProgramUserRequestTO }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.User,
        domain_1.ProgramUserRequestTO]),
    __metadata("design:returntype", Promise)
], UserRequestController.prototype, "createProgramUserRequest", null);
__decorate([
    (0, common_1.Get)(':page/:pageSize/:shortStateUserRequest'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: [domain_1.RequestTenderTO] }),
    (0, swagger_1.ApiParam)({ name: 'page', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'pageSize', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'shortStateUserRequest', type: 'string' }),
    (0, swagger_1.ApiQuery)({ name: 'filter', required: false, type: String, description: 'Filtro opcional para buscar requerimientos' }),
    __param(0, (0, common_1.Param)('page')),
    __param(1, (0, common_1.Param)('pageSize')),
    __param(2, (0, common_1.Query)('filter')),
    __param(3, (0, common_1.Param)('shortStateUserRequest')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String, String]),
    __metadata("design:returntype", Promise)
], UserRequestController.prototype, "getPaginatedUserRequest", null);
__decorate([
    (0, common_1.Put)(''),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: () => String }),
    (0, swagger_1.ApiBody)({ type: domain_1.UpdateStateUserRequest }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.UpdateStateUserRequest]),
    __metadata("design:returntype", Promise)
], UserRequestController.prototype, "update", null);
exports.UserRequestController = UserRequestController = UserRequestController_1 = __decorate([
    (0, common_1.Controller)('user-request'),
    (0, swagger_1.ApiTags)('user-request'),
    __param(0, (0, common_1.Inject)('UserRequestService')),
    __metadata("design:paramtypes", [Object])
], UserRequestController);
//# sourceMappingURL=user-request.controller.js.map