"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var UserController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const definition_1 = require("../../definition");
const api_default_responses_decorator_1 = require("../../decorators/api-default-responses/api-default-responses.decorator");
const allow_roles_decorator_1 = require("../../decorators/allow-profiles/allow-roles.decorator");
const prime_user_decorator_1 = require("../../decorators/prime-user/prime-user.decorator");
const domain_1 = require("../../../domain");
let UserController = UserController_1 = class UserController {
    constructor(userService, userRoleService) {
        this.userService = userService;
        this.userRoleService = userRoleService;
        this.LOGGER = new definition_1.PrimeLogger(UserController_1.name);
    }
    async update(user, userData) {
        this.LOGGER.log(`Updating user with id: ${user.id}`);
        return await this.userService.updateUser(user.id, userData);
    }
    async save(user) {
        this.LOGGER.log(`Saving new user with email: ${user.email}`);
        return await this.userService.createUser(user);
    }
    async findById(user, userId) {
        const userIdParam = userId != 0 ? userId : user.id;
        this.LOGGER.log(`Finding user by id: ${userIdParam}`);
        return await this.userService.getUserById(userIdParam);
    }
    async findAll() {
        this.LOGGER.log('Finding all users');
        return await this.userService.getAllUsers();
    }
    async updateAggrement(user) {
        this.LOGGER.log(`UpdateAggrement user with id: ${user.id}`);
        return await this.userService.updateAggrement(user);
    }
    async updateProfiles(params) {
        this.LOGGER.log(`updateProfiles user with id: ${params}`);
        return await this.userService.updateProfiles(params);
    }
    async findAllPaginated(page, pageSize, email, profile) {
        this.LOGGER.log(`Finding all user profiles with page: ${page}, pageSize: ${pageSize}, profile: ${profile} email: ${email}`);
        return await this.userRoleService.getAllPaginated(page, pageSize, email, profile);
    }
};
exports.UserController = UserController;
__decorate([
    (0, common_1.Put)(),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: domain_1.User }),
    (0, swagger_1.ApiBody)({ type: domain_1.UpdateUser }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.User,
        domain_1.UpdateUser]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "update", null);
__decorate([
    (0, common_1.Post)(),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: domain_1.User }),
    (0, swagger_1.ApiBody)({ type: domain_1.InsertUser }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.InsertUser]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "save", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: domain_1.User }),
    (0, swagger_1.ApiParam)({ name: 'id', type: 'number' }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.User, Number]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "findById", null);
__decorate([
    (0, common_1.Get)(),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: [domain_1.User] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], UserController.prototype, "findAll", null);
__decorate([
    (0, common_1.Put)('update-aggrement'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.User]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "updateAggrement", null);
__decorate([
    (0, common_1.Put)('update-profiles'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.UserRoleTO]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "updateProfiles", null);
__decorate([
    (0, common_1.Get)(':page/:pageSize'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: [domain_1.UserPage] }),
    (0, swagger_1.ApiParam)({ name: 'page', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'pageSize', type: 'number' }),
    (0, swagger_1.ApiQuery)({ name: 'profile', enum: allow_roles_decorator_1.RoleShortNameEnum, required: false }),
    (0, swagger_1.ApiQuery)({ name: 'email', type: 'string', required: false }),
    __param(0, (0, common_1.Param)('page')),
    __param(1, (0, common_1.Param)('pageSize')),
    __param(2, (0, common_1.Query)('email')),
    __param(3, (0, common_1.Query)('profile')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String, String]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "findAllPaginated", null);
exports.UserController = UserController = UserController_1 = __decorate([
    (0, common_1.Controller)('users'),
    (0, swagger_1.ApiTags)('users'),
    __param(0, (0, common_1.Inject)('UserService')),
    __param(1, (0, common_1.Inject)('UserRoleService')),
    __metadata("design:paramtypes", [Object, Object])
], UserController);
//# sourceMappingURL=user.controller.js.map