"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoleShortNameEnum = exports.AllowRoles = exports.ALLOWED_ROLES = void 0;
const common_1 = require("@nestjs/common");
const ALLOWED_ROLES = 'allowedRoles';
exports.ALLOWED_ROLES = ALLOWED_ROLES;
var RoleShortNameEnum;
(function (RoleShortNameEnum) {
    RoleShortNameEnum["USER"] = "profile.normal.user";
    RoleShortNameEnum["ADMIN"] = "profile.normal.admin";
    RoleShortNameEnum["MANAGER"] = "profile.super.manager";
})(RoleShortNameEnum || (exports.RoleShortNameEnum = RoleShortNameEnum = {}));
const AllowRoles = (...shortNames) => (0, common_1.SetMetadata)(ALLOWED_ROLES, shortNames);
exports.AllowRoles = AllowRoles;
//# sourceMappingURL=allow-roles.decorator.js.map