"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var PrimeFirebaseAuthGuard_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrimeFirebaseAuthGuard = void 0;
const common_1 = require("@nestjs/common");
const core_1 = require("@nestjs/core");
const app_exception_logger_1 = require("../../logger/app.exception.logger");
const public_decorator_1 = require("../../../decorators/public/public.decorator");
const allow_roles_decorator_1 = require("../../../decorators/allow-profiles/allow-roles.decorator");
let PrimeFirebaseAuthGuard = PrimeFirebaseAuthGuard_1 = class PrimeFirebaseAuthGuard {
    constructor(firebaseService, userService, userRoleService, reflector) {
        this.firebaseService = firebaseService;
        this.userService = userService;
        this.userRoleService = userRoleService;
        this.reflector = reflector;
        this.LOGGER = new app_exception_logger_1.PrimeLogger(PrimeFirebaseAuthGuard_1.name);
    }
    async canActivate(context) {
        const isPublic = this.reflector.getAllAndOverride(public_decorator_1.IS_PUBLIC_KEY, [
            context.getHandler(),
            context.getClass(),
        ]);
        if (isPublic) {
            return true;
        }
        const request = context.switchToHttp().getRequest();
        const token = this.extractTokenFromHeader(request);
        if (!token) {
            this.LOGGER.error('Token not found in request header');
            throw new common_1.UnauthorizedException();
        }
        let user;
        let roles = [];
        try {
            const decodedToken = await this.firebaseService.verifyIdToken(token);
            request.decodedToken = decodedToken;
            request.accessToken = token;
            user = await this.userService.getUserByExternalId(decodedToken.sub);
            request.user = user ?? undefined;
            if (user) {
                roles = await this.userRoleService.getUserRoles(user.id);
                request.profiles = roles;
            }
        }
        catch (error) {
            this.LOGGER.error(`Error verifying token: ${error.message}`, error);
            throw new common_1.UnauthorizedException(error);
        }
        const allowedUserTypes = this.reflector.get(allow_roles_decorator_1.ALLOWED_ROLES, context.getHandler());
        if (allowedUserTypes && allowedUserTypes.length > 0) {
            if (!user || !roles || roles.length === 0) {
                throw new common_1.UnauthorizedException();
            }
            const allowedProfiles = roles.filter((role) => allowedUserTypes.includes(role.shortName));
            if (allowedProfiles.length === 0) {
                throw new common_1.ForbiddenException();
            }
        }
        return true;
    }
    extractTokenFromHeader(request) {
        const [type, token] = request.headers.authorization?.split(' ') ?? [];
        return type === 'Bearer' ? token : undefined;
    }
};
exports.PrimeFirebaseAuthGuard = PrimeFirebaseAuthGuard;
exports.PrimeFirebaseAuthGuard = PrimeFirebaseAuthGuard = PrimeFirebaseAuthGuard_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('FirebaseService')),
    __param(1, (0, common_1.Inject)('UserService')),
    __param(2, (0, common_1.Inject)('UserRoleService')),
    __metadata("design:paramtypes", [Object, Object, Object, core_1.Reflector])
], PrimeFirebaseAuthGuard);
//# sourceMappingURL=prime-firebase-auth.guard.js.map