"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DrizzleLogger = void 0;
const common_1 = require("@nestjs/common");
class DrizzleLogger {
    constructor(shouldLog = false, paramPrefix) {
        this.shouldLog = shouldLog;
        this.paramPrefix = paramPrefix;
    }
    logQuery(query, params) {
        if (!this.shouldLog) {
            return;
        }
        if (this.paramPrefix) {
            query = query.replace(/\$(\d+|\w+)/g, (param) => {
                const paramName = param.replace(/\$/, '');
                return `${this.paramPrefix}${paramName}`;
            });
        }
        common_1.Logger.debug(`Query: ${query}; with params: ${JSON.stringify(params)}`, 'DrizzleModule');
    }
}
exports.DrizzleLogger = DrizzleLogger;
//# sourceMappingURL=drizzle.logger.js.map