"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var DBConfigService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBConfigService = void 0;
const common_1 = require("@nestjs/common");
const drizzle_orm_1 = require("drizzle-orm");
const migrator_1 = require("drizzle-orm/mysql2/migrator");
const fs = require("fs");
const node_util_1 = require("node:util");
const path = require("path");
const drizzle_constants_1 = require("./drizzle.constants");
const app_exception_logger_1 = require("../definition/logger/app.exception.logger");
let DBConfigService = DBConfigService_1 = class DBConfigService {
    constructor(config) {
        this.config = config;
        this.LOGGER = new app_exception_logger_1.PrimeLogger(DBConfigService_1.name);
    }
    get conn() {
        return this.config.drizzle;
    }
    get pool() {
        return this.config.connection;
    }
    async migrate() {
        return await (0, migrator_1.migrate)(this.conn, {
            migrationsFolder: `./src/framework/infrastructure/drizzle/migrations/output`,
        })
            .then(() => {
            this.LOGGER.debug('Migrations executed successfully', 'DBConfigService');
            return true;
        })
            .catch((error) => {
            this.LOGGER.error(`Error executing migrations: ${(0, node_util_1.inspect)(error)}`, 'DBConfigService');
            return false;
        });
    }
    async seed() {
        const seedFiles = [
            'ddl_schema.sql',
            'profile.sql',
            'type_master.sql',
            'truncate.sql',
            'continent.sql',
            'country.sql',
            'subdivision.sql',
            'administrative_division.sql',
        ];
        const results = [];
        const promises = [];
        for (const file of seedFiles) {
            const result = { file, error: 0, success: 0 };
            const filePath = path.join(__dirname, '..', '..', '..', 'infrastructure', 'drizzle', 'migrations', 'seed', file);
            const imports = fs.readFileSync(filePath, 'utf8');
            const sqlStatements = imports
                .split(';')
                .map((stmt) => stmt.trim())
                .filter((stmt) => stmt.length > 0);
            for (const statement of sqlStatements) {
                promises.push(this.conn
                    .execute(drizzle_orm_1.sql.raw(statement))
                    .then(() => {
                    result.success++;
                })
                    .catch(() => {
                    result.error++;
                }));
            }
            results.push(result);
        }
        await Promise.all(promises);
        return results;
    }
};
exports.DBConfigService = DBConfigService;
exports.DBConfigService = DBConfigService = DBConfigService_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)(drizzle_constants_1.MYSQL_CONNECTION)),
    __metadata("design:paramtypes", [Object])
], DBConfigService);
exports.default = { DBConfigService };
//# sourceMappingURL=drizzle.provider.js.map