import { HistoryMetadata, Metadata } from 'src/licitaapp/domain/entities/metadata.to';
import { Licitacion } from 'src/licitaapp/domain/type';
import { z } from 'zod';
import { RoleShortNameEnum } from '../../decorators/allow-profiles/allow-roles.decorator';
import { KeywordOrigin } from 'src/licitaapp/domain';
import { ApplicationTypeEnum } from 'src/licitaapp/domain/enum/enum.definition';
import { TypeMasterDiscriminatorEnum } from 'src/framework/domain/enum/enum.definition';
import { AgileTenderFullInfoTO, MatchWordTO } from 'src/licitaapp';
export declare const userTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "user";
    schema: undefined;
    columns: {
        agreementAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "agreement_at";
            tableName: "user";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        name: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "name";
            tableName: "user";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        email: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "email";
            tableName: "user";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        lastName: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "last_name";
            tableName: "user";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        lastname2: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "last_name_2";
            tableName: "user";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        cellPhone: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "cell_phone";
            tableName: "user";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        externalId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "external_id";
            tableName: "user";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        lastAccess: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "last_access";
            tableName: "user";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "user";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "user";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "user";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "user";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "user";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const roleTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "profile";
    schema: undefined;
    columns: {
        name: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "name";
            tableName: "profile";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        shortName: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "short_name";
            tableName: "profile";
            dataType: "string";
            columnType: "MySqlEnumColumn";
            data: RoleShortNameEnum;
            driverParam: string;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {
            $type: RoleShortNameEnum;
        }>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "profile";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "profile";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "profile";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "profile";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "profile";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const userRoleTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "user_profile";
    schema: undefined;
    columns: {
        userId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "user_id";
            tableName: "user_profile";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: true;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        roleId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "profile_id";
            tableName: "user_profile";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: true;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const companyTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "company";
    schema: undefined;
    columns: {
        dni: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "dni";
            tableName: "company";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        socialReason: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "social_reason";
            tableName: "company";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        checkTender: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "check_tender";
            tableName: "company";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "company";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "company";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "company";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "company";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "company";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const companySubdivisionTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "company_subdivision";
    schema: undefined;
    columns: {
        companyId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "company_id";
            tableName: "company_subdivision";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: true;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        subdivisionId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "subdivision_id";
            tableName: "company_subdivision";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: true;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const userCompanyTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "user_company";
    schema: undefined;
    columns: {
        userId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "user_id";
            tableName: "user_company";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: true;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        companyId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "company_id";
            tableName: "user_company";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: true;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const typeMasterTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "type_master";
    schema: undefined;
    columns: {
        discriminator: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "discriminator";
            tableName: "type_master";
            dataType: "string";
            columnType: "MySqlEnumColumn";
            data: TypeMasterDiscriminatorEnum;
            driverParam: string;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [TypeMasterDiscriminatorEnum.TUTORIAL_TYPE, TypeMasterDiscriminatorEnum.STATE_REQUEST_TYPE];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {
            $type: TypeMasterDiscriminatorEnum;
        }>;
        shortName: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "short_name";
            tableName: "type_master";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        name: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "name";
            tableName: "type_master";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        order: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "order";
            tableName: "type_master";
            dataType: "number";
            columnType: "MySqlSmallInt";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "type_master";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "type_master";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "type_master";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "type_master";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "type_master";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const keywordTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "keyword";
    schema: undefined;
    columns: {
        value: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "value";
            tableName: "keyword";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        codeCategoriaMercadoPublico: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "code_categoria_mercado_publico";
            tableName: "keyword";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        origin: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "origin";
            tableName: "keyword";
            dataType: "string";
            columnType: "MySqlEnumColumn";
            data: KeywordOrigin;
            driverParam: string;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [KeywordOrigin.MERCADO_PUBLICO, KeywordOrigin.USER, KeywordOrigin.ADMIN];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {
            $type: KeywordOrigin;
        }>;
        metadata: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "metadata";
            tableName: "keyword";
            dataType: "json";
            columnType: "MySqlJson";
            data: Metadata;
            driverParam: string;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {
            $type: Metadata;
        }>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "keyword";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "keyword";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "keyword";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "keyword";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "keyword";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const tenderTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "tender";
    schema: undefined;
    columns: {
        closeDate: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "close_date";
            tableName: "tender";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        code: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "code";
            tableName: "tender";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        name: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "name";
            tableName: "tender";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        description: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "description";
            tableName: "tender";
            dataType: "string";
            columnType: "MySqlText";
            data: string;
            driverParam: string;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        subdivisionId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "subdivision_id";
            tableName: "tender";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        details: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "details";
            tableName: "tender";
            dataType: "json";
            columnType: "MySqlJson";
            data: Licitacion;
            driverParam: string;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {
            $type: Licitacion;
        }>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "tender";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "tender";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "tender";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "tender";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "tender";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const agileTenderTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "tender_agile";
    schema: undefined;
    columns: {
        closeDate: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "close_date";
            tableName: "tender_agile";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        code: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "code";
            tableName: "tender_agile";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        name: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "name";
            tableName: "tender_agile";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        description: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "description";
            tableName: "tender_agile";
            dataType: "string";
            columnType: "MySqlText";
            data: string;
            driverParam: string;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        descriptionLocation: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "description_location";
            tableName: "tender_agile";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        details: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "details";
            tableName: "tender_agile";
            dataType: "json";
            columnType: "MySqlJson";
            data: AgileTenderFullInfoTO;
            driverParam: string;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {
            $type: AgileTenderFullInfoTO;
        }>;
        subdivisionId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "subdivision_id";
            tableName: "tender_agile";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        amountCLP: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "amount_clp";
            tableName: "tender_agile";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "tender_agile";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "tender_agile";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "tender_agile";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "tender_agile";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "tender_agile";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const matchingWordTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "matching_word";
    schema: undefined;
    columns: {
        coincidence: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "coincidence";
            tableName: "matching_word";
            dataType: "json";
            columnType: "MySqlJson";
            data: MatchWordTO;
            driverParam: string;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {
            $type: MatchWordTO;
        }>;
        subdivisionId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "subdivision_id";
            tableName: "matching_word";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "matching_word";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "matching_word";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "matching_word";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "matching_word";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "matching_word";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const userCompanyTenderTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "user_company_tender";
    schema: undefined;
    columns: {
        isFavorite: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "is_favorite";
            tableName: "user_company_tender";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        source: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "source";
            tableName: "user_company_tender";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        matchResult: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "match_result";
            tableName: "user_company_tender";
            dataType: "string";
            columnType: "MySqlText";
            data: string;
            driverParam: string;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "user_company_tender";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "user_company_tender";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "user_company_tender";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "user_company_tender";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        userId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "user_id";
            tableName: "user_company_tender";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: true;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        companyId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "company_id";
            tableName: "user_company_tender";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: true;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        tenderId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "tender_id";
            tableName: "user_company_tender";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: true;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const userCompanyAgileTenderTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "user_company_agile_tender";
    schema: undefined;
    columns: {
        isFavorite: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "is_favorite";
            tableName: "user_company_agile_tender";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        matchResult: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "match_result";
            tableName: "user_company_agile_tender";
            dataType: "string";
            columnType: "MySqlText";
            data: string;
            driverParam: string;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "user_company_agile_tender";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "user_company_agile_tender";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "user_company_agile_tender";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "user_company_agile_tender";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        userId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "user_id";
            tableName: "user_company_agile_tender";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: true;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        companyId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "company_id";
            tableName: "user_company_agile_tender";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: true;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        agileTenderId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "agile_tender_id";
            tableName: "user_company_agile_tender";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: true;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const userHistoryTenderTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "user_history_tender";
    schema: undefined;
    columns: {
        userId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "user_id";
            tableName: "user_history_tender";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        tenderId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "tender_id";
            tableName: "user_history_tender";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        codeTender: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "code_tender";
            tableName: "user_history_tender";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        metadata: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "metadata";
            tableName: "user_history_tender";
            dataType: "json";
            columnType: "MySqlJson";
            data: HistoryMetadata;
            driverParam: string;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {
            $type: HistoryMetadata;
        }>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "user_history_tender";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "user_history_tender";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "user_history_tender";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "user_history_tender";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "user_history_tender";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const continentTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "continent";
    schema: undefined;
    columns: {
        code: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "code";
            tableName: "continent";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        name: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "name";
            tableName: "continent";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "continent";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "continent";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "continent";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "continent";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "continent";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const countryTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "country";
    schema: undefined;
    columns: {
        code: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "code";
            tableName: "country";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        iso3: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "iso3";
            tableName: "country";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        number: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "number";
            tableName: "country";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        continentId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "continent_id";
            tableName: "country";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        name: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "name";
            tableName: "country";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        fullName: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "full_name";
            tableName: "country";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "country";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "country";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "country";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "country";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "country";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const subdivisionTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "subdivision";
    schema: undefined;
    columns: {
        code: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "code";
            tableName: "subdivision";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        countryId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "country_id";
            tableName: "subdivision";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        name: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "name";
            tableName: "subdivision";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "subdivision";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "subdivision";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "subdivision";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "subdivision";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "subdivision";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const userDeviceTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "user_device";
    schema: undefined;
    columns: {
        userId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "user_id";
            tableName: "user_device";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        token: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "token";
            tableName: "user_device";
            dataType: "string";
            columnType: "MySqlText";
            data: string;
            driverParam: string;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        information: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "information";
            tableName: "user_device";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "user_device";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "user_device";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "user_device";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "user_device";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "user_device";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const administrativeDivisionTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "administrative_division";
    schema: undefined;
    columns: {
        code: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "code";
            tableName: "administrative_division";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        subdivisionId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "subdivision_id";
            tableName: "administrative_division";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        name: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "name";
            tableName: "administrative_division";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "administrative_division";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "administrative_division";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "administrative_division";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "administrative_division";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "administrative_division";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const userRequestTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "user_request";
    schema: undefined;
    columns: {
        userId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "user_id";
            tableName: "user_request";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        companyId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "company_id";
            tableName: "user_request";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        stateRequestTypeId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "state_request_type_id";
            tableName: "user_request";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        title: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "title";
            tableName: "user_request";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        description: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "description";
            tableName: "user_request";
            dataType: "string";
            columnType: "MySqlText";
            data: string;
            driverParam: string;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        tenderId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "tender_id";
            tableName: "user_request";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "user_request";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "user_request";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "user_request";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "user_request";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "user_request";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const notificationRecordTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "notification_record";
    schema: undefined;
    columns: {
        monthFilterTender: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "month_filter_tender";
            tableName: "notification_record";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        userId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "user_id";
            tableName: "notification_record";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        tenderId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "tender_id";
            tableName: "notification_record";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        subdivisionId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "subdivision_id";
            tableName: "notification_record";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        title: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "title";
            tableName: "notification_record";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        defaultMessage: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "default_message";
            tableName: "notification_record";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        sendEmail: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "send_email";
            tableName: "notification_record";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        amountWords: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "amount_words";
            tableName: "notification_record";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        amountGeo: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "amount_geo";
            tableName: "notification_record";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        isAdmin: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "is_admin";
            tableName: "notification_record";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "notification_record";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "notification_record";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "notification_record";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "notification_record";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "notification_record";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const applicationLogTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "application_log";
    schema: undefined;
    columns: {
        userName: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "user_name";
            tableName: "application_log";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        statusTypeId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "status_type_id";
            tableName: "application_log";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        detail: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "detail";
            tableName: "application_log";
            dataType: "string";
            columnType: "MySqlText";
            data: string;
            driverParam: string;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        type: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "type";
            tableName: "application_log";
            dataType: "string";
            columnType: "MySqlEnumColumn";
            data: ApplicationTypeEnum;
            driverParam: string;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [ApplicationTypeEnum.CHECK_TENDER_FAVORITES_TO_CLOSE_LOG, ApplicationTypeEnum.DAILY_EMAIL_SUMMARY_LOG, ApplicationTypeEnum.CHECK_NEW_TENDERS_USER_LOG, ApplicationTypeEnum.METADATA_TASK_LOG, ApplicationTypeEnum.KEYWORDS_LOG, ApplicationTypeEnum.TENDER_COMPLETE_STATE_LOG, ApplicationTypeEnum.TENDER_CHECK_CLOSE_DATE_LOG, ApplicationTypeEnum.TENDER_DELETE_CLOSE_DATE_LOG, ApplicationTypeEnum.TENDER_CHECK_SUBDIVISION_LOG, ApplicationTypeEnum.SUMMARY_ADMIN_LOG, ApplicationTypeEnum.RECALCULATE_TENDER_DASHBOARD_LOG, ApplicationTypeEnum.SEARCH_TENDERS_MERCADO_PUBLICO_LOG, ApplicationTypeEnum.ERRASE_OLD_TENDERS_LOG, ApplicationTypeEnum.TENDERS_OF_THE_DAY_LOG, ApplicationTypeEnum.TENDER_ERRASE_OLD_TENDERS_LOG, ApplicationTypeEnum.FETCH_TENDER_AGILE_LOG, ApplicationTypeEnum.METADATA_AGILE_TENDERS_LOG, ApplicationTypeEnum.FETCH_JOIN_AGILE_TENDER_LOG];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {
            $type: ApplicationTypeEnum;
        }>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "application_log";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "application_log";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "application_log";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "application_log";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "application_log";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const userCampaignTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "user_campaign";
    schema: undefined;
    columns: {
        description: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "description";
            tableName: "user_campaign";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        title: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "title";
            tableName: "user_campaign";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        defaultMessage: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "default_message";
            tableName: "user_campaign";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        dayOfWeek: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "day_of_week";
            tableName: "user_campaign";
            dataType: "string";
            columnType: "MySqlVarChar";
            data: string;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        defHour: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "def_hour";
            tableName: "user_campaign";
            dataType: "number";
            columnType: "MySqlSmallInt";
            data: number;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        defMinute: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "def_minute";
            tableName: "user_campaign";
            dataType: "number";
            columnType: "MySqlSmallInt";
            data: number;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "user_campaign";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "user_campaign";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "user_campaign";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "user_campaign";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "user_campaign";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const tenderKeywordCategoryTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "tender_keyword_category";
    schema: undefined;
    columns: {
        agileTenderId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "agile_tender_id";
            tableName: "tender_keyword_category";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        normalTenderId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "normal_tender_id";
            tableName: "tender_keyword_category";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        codeMercadoPublico: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "code_mercado_publico";
            tableName: "tender_keyword_category";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        itemDescription: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "item_description";
            tableName: "tender_keyword_category";
            dataType: "string";
            columnType: "MySqlText";
            data: string;
            driverParam: string;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: [string, ...string[]];
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "created_at";
            tableName: "tender_keyword_category";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "updated_at";
            tableName: "tender_keyword_category";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "deleted_at";
            tableName: "tender_keyword_category";
            dataType: "date";
            columnType: "MySqlTimestamp";
            data: Date;
            driverParam: string | number;
            notNull: false;
            hasDefault: false;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        active: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "active";
            tableName: "tender_keyword_category";
            dataType: "boolean";
            columnType: "MySqlBoolean";
            data: boolean;
            driverParam: number | boolean;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: false;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        id: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "id";
            tableName: "tender_keyword_category";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: true;
            isPrimaryKey: true;
            isAutoincrement: true;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const companyKeywordTable: import("drizzle-orm/mysql-core").MySqlTableWithColumns<{
    name: "company_keyword";
    schema: undefined;
    columns: {
        companyId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "company_id";
            tableName: "company_keyword";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: true;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
        keywordId: import("drizzle-orm/mysql-core").MySqlColumn<{
            name: "keyword_id";
            tableName: "company_keyword";
            dataType: "number";
            columnType: "MySqlBigInt53";
            data: number;
            driverParam: string | number;
            notNull: true;
            hasDefault: false;
            isPrimaryKey: true;
            isAutoincrement: false;
            hasRuntimeDefault: false;
            enumValues: undefined;
            baseColumn: never;
            identity: undefined;
            generated: undefined;
        }, {}, {}>;
    };
    dialect: "mysql";
}>;
export declare const companyKeywordTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    companyId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "company_id";
        tableName: "company_keyword";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: true;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    keywordId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "keyword_id";
        tableName: "company_keyword";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: true;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const companyKeywordTableUpdateSchema: z.ZodObject<{
    companyId: z.ZodOptional<z.ZodNumber>;
    keywordId: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    companyId?: number | undefined;
    keywordId?: number | undefined;
}, {
    companyId?: number | undefined;
    keywordId?: number | undefined;
}>;
export declare const companyKeywordTableSelectSchema: z.ZodObject<Pick<{
    companyId: z.ZodNumber;
    keywordId: z.ZodNumber;
}, "companyId" | "keywordId">, "strip", z.ZodTypeAny, {
    companyId: number;
    keywordId: number;
}, {
    companyId: number;
    keywordId: number;
}>;
export declare const applicationLogTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    userName: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "user_name";
        tableName: "application_log";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    statusTypeId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "status_type_id";
        tableName: "application_log";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    detail: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "detail";
        tableName: "application_log";
        dataType: "string";
        columnType: "MySqlText";
        data: string;
        driverParam: string;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    type: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "type";
        tableName: "application_log";
        dataType: "string";
        columnType: "MySqlEnumColumn";
        data: ApplicationTypeEnum;
        driverParam: string;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [ApplicationTypeEnum.CHECK_TENDER_FAVORITES_TO_CLOSE_LOG, ApplicationTypeEnum.DAILY_EMAIL_SUMMARY_LOG, ApplicationTypeEnum.CHECK_NEW_TENDERS_USER_LOG, ApplicationTypeEnum.METADATA_TASK_LOG, ApplicationTypeEnum.KEYWORDS_LOG, ApplicationTypeEnum.TENDER_COMPLETE_STATE_LOG, ApplicationTypeEnum.TENDER_CHECK_CLOSE_DATE_LOG, ApplicationTypeEnum.TENDER_DELETE_CLOSE_DATE_LOG, ApplicationTypeEnum.TENDER_CHECK_SUBDIVISION_LOG, ApplicationTypeEnum.SUMMARY_ADMIN_LOG, ApplicationTypeEnum.RECALCULATE_TENDER_DASHBOARD_LOG, ApplicationTypeEnum.SEARCH_TENDERS_MERCADO_PUBLICO_LOG, ApplicationTypeEnum.ERRASE_OLD_TENDERS_LOG, ApplicationTypeEnum.TENDERS_OF_THE_DAY_LOG, ApplicationTypeEnum.TENDER_ERRASE_OLD_TENDERS_LOG, ApplicationTypeEnum.FETCH_TENDER_AGILE_LOG, ApplicationTypeEnum.METADATA_AGILE_TENDERS_LOG, ApplicationTypeEnum.FETCH_JOIN_AGILE_TENDER_LOG];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {
        $type: ApplicationTypeEnum;
    }>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "application_log";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "application_log";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "application_log";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "application_log";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    id: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "id";
        tableName: "application_log";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: true;
        isAutoincrement: true;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const applicationLogTableUpdateSchema: z.ZodObject<{
    userName: z.ZodOptional<z.ZodString>;
    statusTypeId: z.ZodOptional<z.ZodNumber>;
    detail: z.ZodOptional<z.ZodString>;
    type: z.ZodOptional<z.ZodEnum<[ApplicationTypeEnum.CHECK_TENDER_FAVORITES_TO_CLOSE_LOG, ApplicationTypeEnum.DAILY_EMAIL_SUMMARY_LOG, ApplicationTypeEnum.CHECK_NEW_TENDERS_USER_LOG, ApplicationTypeEnum.METADATA_TASK_LOG, ApplicationTypeEnum.KEYWORDS_LOG, ApplicationTypeEnum.TENDER_COMPLETE_STATE_LOG, ApplicationTypeEnum.TENDER_CHECK_CLOSE_DATE_LOG, ApplicationTypeEnum.TENDER_DELETE_CLOSE_DATE_LOG, ApplicationTypeEnum.TENDER_CHECK_SUBDIVISION_LOG, ApplicationTypeEnum.SUMMARY_ADMIN_LOG, ApplicationTypeEnum.RECALCULATE_TENDER_DASHBOARD_LOG, ApplicationTypeEnum.SEARCH_TENDERS_MERCADO_PUBLICO_LOG, ApplicationTypeEnum.ERRASE_OLD_TENDERS_LOG, ApplicationTypeEnum.TENDERS_OF_THE_DAY_LOG, ApplicationTypeEnum.TENDER_ERRASE_OLD_TENDERS_LOG, ApplicationTypeEnum.FETCH_TENDER_AGILE_LOG, ApplicationTypeEnum.METADATA_AGILE_TENDERS_LOG, ApplicationTypeEnum.FETCH_JOIN_AGILE_TENDER_LOG]>>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    id: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
}, "strip", z.ZodTypeAny, {
    type?: ApplicationTypeEnum | undefined;
    id?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    userName?: string | undefined;
    statusTypeId?: number | undefined;
    detail?: string | undefined;
    deletedAt?: Date | null | undefined;
}, {
    type?: ApplicationTypeEnum | undefined;
    id?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    userName?: string | undefined;
    statusTypeId?: number | undefined;
    detail?: string | undefined;
    deletedAt?: Date | null | undefined;
}>;
export declare const applicationLogTableSelectSchema: z.ZodObject<Pick<{
    userName: z.ZodString;
    statusTypeId: z.ZodNumber;
    detail: z.ZodString;
    type: z.ZodEnum<[ApplicationTypeEnum.CHECK_TENDER_FAVORITES_TO_CLOSE_LOG, ApplicationTypeEnum.DAILY_EMAIL_SUMMARY_LOG, ApplicationTypeEnum.CHECK_NEW_TENDERS_USER_LOG, ApplicationTypeEnum.METADATA_TASK_LOG, ApplicationTypeEnum.KEYWORDS_LOG, ApplicationTypeEnum.TENDER_COMPLETE_STATE_LOG, ApplicationTypeEnum.TENDER_CHECK_CLOSE_DATE_LOG, ApplicationTypeEnum.TENDER_DELETE_CLOSE_DATE_LOG, ApplicationTypeEnum.TENDER_CHECK_SUBDIVISION_LOG, ApplicationTypeEnum.SUMMARY_ADMIN_LOG, ApplicationTypeEnum.RECALCULATE_TENDER_DASHBOARD_LOG, ApplicationTypeEnum.SEARCH_TENDERS_MERCADO_PUBLICO_LOG, ApplicationTypeEnum.ERRASE_OLD_TENDERS_LOG, ApplicationTypeEnum.TENDERS_OF_THE_DAY_LOG, ApplicationTypeEnum.TENDER_ERRASE_OLD_TENDERS_LOG, ApplicationTypeEnum.FETCH_TENDER_AGILE_LOG, ApplicationTypeEnum.METADATA_AGILE_TENDERS_LOG, ApplicationTypeEnum.FETCH_JOIN_AGILE_TENDER_LOG]>;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    id: z.ZodNumber;
}, "type" | "id" | "userName" | "statusTypeId" | "detail">, "strip", z.ZodTypeAny, {
    type: ApplicationTypeEnum;
    id: number;
    userName: string;
    statusTypeId: number;
    detail: string;
}, {
    type: ApplicationTypeEnum;
    id: number;
    userName: string;
    statusTypeId: number;
    detail: string;
}>;
export declare const notificationRecordTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    monthFilterTender: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "month_filter_tender";
        tableName: "notification_record";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    userId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "user_id";
        tableName: "notification_record";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    tenderId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "tender_id";
        tableName: "notification_record";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    subdivisionId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "subdivision_id";
        tableName: "notification_record";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    title: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "title";
        tableName: "notification_record";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    defaultMessage: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "default_message";
        tableName: "notification_record";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    sendEmail: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "send_email";
        tableName: "notification_record";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    amountWords: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "amount_words";
        tableName: "notification_record";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    amountGeo: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "amount_geo";
        tableName: "notification_record";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    isAdmin: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "is_admin";
        tableName: "notification_record";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "notification_record";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "notification_record";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "notification_record";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "notification_record";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    id: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "id";
        tableName: "notification_record";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: true;
        isAutoincrement: true;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const notificationRecordTableUpdateSchema: z.ZodObject<{
    monthFilterTender: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    userId: z.ZodOptional<z.ZodNumber>;
    tenderId: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodNumber>>>;
    subdivisionId: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodNumber>>>;
    title: z.ZodOptional<z.ZodString>;
    defaultMessage: z.ZodOptional<z.ZodString>;
    sendEmail: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    amountWords: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
    amountGeo: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
    isAdmin: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    id: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
}, "strip", z.ZodTypeAny, {
    title?: string | undefined;
    id?: number | undefined;
    tenderId?: number | null | undefined;
    userId?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    defaultMessage?: string | undefined;
    subdivisionId?: number | null | undefined;
    active?: boolean | undefined;
    monthFilterTender?: Date | null | undefined;
    amountWords?: number | undefined;
    amountGeo?: number | undefined;
    sendEmail?: boolean | undefined;
    isAdmin?: boolean | undefined;
    deletedAt?: Date | null | undefined;
}, {
    title?: string | undefined;
    id?: number | undefined;
    tenderId?: number | null | undefined;
    userId?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    defaultMessage?: string | undefined;
    subdivisionId?: number | null | undefined;
    active?: boolean | undefined;
    monthFilterTender?: Date | null | undefined;
    amountWords?: number | undefined;
    amountGeo?: number | undefined;
    sendEmail?: boolean | undefined;
    isAdmin?: boolean | undefined;
    deletedAt?: Date | null | undefined;
}>;
export declare const notificationRecordTableSelectSchema: z.ZodObject<Pick<{
    monthFilterTender: z.ZodNullable<z.ZodDate>;
    userId: z.ZodNumber;
    tenderId: z.ZodNullable<z.ZodNumber>;
    subdivisionId: z.ZodNullable<z.ZodNumber>;
    title: z.ZodString;
    defaultMessage: z.ZodString;
    sendEmail: z.ZodBoolean;
    amountWords: z.ZodNumber;
    amountGeo: z.ZodNumber;
    isAdmin: z.ZodBoolean;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    id: z.ZodNumber;
}, "title" | "id" | "tenderId" | "userId" | "defaultMessage" | "subdivisionId" | "amountWords" | "amountGeo" | "sendEmail" | "isAdmin">, "strip", z.ZodTypeAny, {
    title: string;
    id: number;
    tenderId: number | null;
    userId: number;
    defaultMessage: string;
    subdivisionId: number | null;
    amountWords: number;
    amountGeo: number;
    sendEmail: boolean;
    isAdmin: boolean;
}, {
    title: string;
    id: number;
    tenderId: number | null;
    userId: number;
    defaultMessage: string;
    subdivisionId: number | null;
    amountWords: number;
    amountGeo: number;
    sendEmail: boolean;
    isAdmin: boolean;
}>;
export declare const userTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    agreementAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "agreement_at";
        tableName: "user";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    name: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "name";
        tableName: "user";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    email: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "email";
        tableName: "user";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    lastName: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "last_name";
        tableName: "user";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    lastname2: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "last_name_2";
        tableName: "user";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    cellPhone: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "cell_phone";
        tableName: "user";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    externalId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "external_id";
        tableName: "user";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    lastAccess: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "last_access";
        tableName: "user";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "user";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "user";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "user";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "user";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    id: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "id";
        tableName: "user";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: true;
        isAutoincrement: true;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const userTableUpdateSchema: z.ZodObject<{
    agreementAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    name: z.ZodOptional<z.ZodString>;
    email: z.ZodOptional<z.ZodString>;
    lastName: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodString>>>;
    lastname2: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodString>>>;
    cellPhone: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodString>>>;
    externalId: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodString>>>;
    lastAccess: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    id: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
}, "strip", z.ZodTypeAny, {
    name?: string | undefined;
    id?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    cellPhone?: string | null | undefined;
    email?: string | undefined;
    lastName?: string | null | undefined;
    lastname2?: string | null | undefined;
    externalId?: string | null | undefined;
    lastAccess?: Date | null | undefined;
    agreementAt?: Date | null | undefined;
    deletedAt?: Date | null | undefined;
}, {
    name?: string | undefined;
    id?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    cellPhone?: string | null | undefined;
    email?: string | undefined;
    lastName?: string | null | undefined;
    lastname2?: string | null | undefined;
    externalId?: string | null | undefined;
    lastAccess?: Date | null | undefined;
    agreementAt?: Date | null | undefined;
    deletedAt?: Date | null | undefined;
}>;
export declare const userTableSelectSchema: z.ZodObject<Pick<{
    agreementAt: z.ZodNullable<z.ZodDate>;
    name: z.ZodString;
    email: z.ZodString;
    lastName: z.ZodNullable<z.ZodString>;
    lastname2: z.ZodNullable<z.ZodString>;
    cellPhone: z.ZodNullable<z.ZodString>;
    externalId: z.ZodNullable<z.ZodString>;
    lastAccess: z.ZodNullable<z.ZodDate>;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    id: z.ZodNumber;
}, "name" | "id" | "cellPhone" | "email" | "lastName" | "lastname2">, "strip", z.ZodTypeAny, {
    name: string;
    id: number;
    cellPhone: string | null;
    email: string;
    lastName: string | null;
    lastname2: string | null;
}, {
    name: string;
    id: number;
    cellPhone: string | null;
    email: string;
    lastName: string | null;
    lastname2: string | null;
}>;
export declare const roleTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    name: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "name";
        tableName: "profile";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    shortName: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "short_name";
        tableName: "profile";
        dataType: "string";
        columnType: "MySqlEnumColumn";
        data: RoleShortNameEnum;
        driverParam: string;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {
        $type: RoleShortNameEnum;
    }>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "profile";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "profile";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "profile";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "profile";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    id: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "id";
        tableName: "profile";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: true;
        isAutoincrement: true;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const roleTableUpdateSchema: z.ZodObject<{
    name: z.ZodOptional<z.ZodString>;
    shortName: z.ZodOptional<z.ZodString>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    id: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
}, "strip", z.ZodTypeAny, {
    name?: string | undefined;
    id?: number | undefined;
    shortName?: string | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    deletedAt?: Date | null | undefined;
}, {
    name?: string | undefined;
    id?: number | undefined;
    shortName?: string | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    deletedAt?: Date | null | undefined;
}>;
export declare const roleTableSelectSchema: z.ZodObject<Pick<{
    name: z.ZodString;
    shortName: z.ZodString;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    id: z.ZodNumber;
}, "name" | "id" | "shortName">, "strip", z.ZodTypeAny, {
    name: string;
    id: number;
    shortName: string;
}, {
    name: string;
    id: number;
    shortName: string;
}>;
export declare const typeMasterTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    discriminator: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "discriminator";
        tableName: "type_master";
        dataType: "string";
        columnType: "MySqlEnumColumn";
        data: TypeMasterDiscriminatorEnum;
        driverParam: string;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [TypeMasterDiscriminatorEnum.TUTORIAL_TYPE, TypeMasterDiscriminatorEnum.STATE_REQUEST_TYPE];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {
        $type: TypeMasterDiscriminatorEnum;
    }>;
    shortName: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "short_name";
        tableName: "type_master";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    name: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "name";
        tableName: "type_master";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    order: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "order";
        tableName: "type_master";
        dataType: "number";
        columnType: "MySqlSmallInt";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "type_master";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "type_master";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "type_master";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "type_master";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    id: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "id";
        tableName: "type_master";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: true;
        isAutoincrement: true;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const typeMasterTableUpdateSchema: z.ZodObject<{
    discriminator: z.ZodOptional<z.ZodEnum<[TypeMasterDiscriminatorEnum.TUTORIAL_TYPE, TypeMasterDiscriminatorEnum.STATE_REQUEST_TYPE]>>;
    shortName: z.ZodOptional<z.ZodString>;
    name: z.ZodOptional<z.ZodString>;
    order: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    id: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
}, "strip", z.ZodTypeAny, {
    name?: string | undefined;
    discriminator?: TypeMasterDiscriminatorEnum | undefined;
    id?: number | undefined;
    shortName?: string | undefined;
    order?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    deletedAt?: Date | null | undefined;
}, {
    name?: string | undefined;
    discriminator?: TypeMasterDiscriminatorEnum | undefined;
    id?: number | undefined;
    shortName?: string | undefined;
    order?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    deletedAt?: Date | null | undefined;
}>;
export declare const typeMasterTableSelectSchema: z.ZodObject<Pick<{
    discriminator: z.ZodEnum<[TypeMasterDiscriminatorEnum.TUTORIAL_TYPE, TypeMasterDiscriminatorEnum.STATE_REQUEST_TYPE]>;
    shortName: z.ZodString;
    name: z.ZodString;
    order: z.ZodNumber;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    id: z.ZodNumber;
}, "name" | "discriminator" | "id" | "shortName" | "order">, "strip", z.ZodTypeAny, {
    name: string;
    discriminator: TypeMasterDiscriminatorEnum;
    id: number;
    shortName: string;
    order: number;
}, {
    name: string;
    discriminator: TypeMasterDiscriminatorEnum;
    id: number;
    shortName: string;
    order: number;
}>;
export declare const userRoleTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    userId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "user_id";
        tableName: "user_profile";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: true;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    roleId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "profile_id";
        tableName: "user_profile";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: true;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const userRoleTableUpdateSchema: z.ZodObject<{
    userId: z.ZodOptional<z.ZodNumber>;
    roleId: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    userId?: number | undefined;
    roleId?: number | undefined;
}, {
    userId?: number | undefined;
    roleId?: number | undefined;
}>;
export declare const userRoleTableSelectSchema: z.ZodObject<Pick<{
    userId: z.ZodNumber;
    roleId: z.ZodNumber;
}, "userId" | "roleId">, "strip", z.ZodTypeAny, {
    userId: number;
    roleId: number;
}, {
    userId: number;
    roleId: number;
}>;
export declare const companyTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    dni: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "dni";
        tableName: "company";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    socialReason: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "social_reason";
        tableName: "company";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    checkTender: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "check_tender";
        tableName: "company";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "company";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "company";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "company";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "company";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    id: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "id";
        tableName: "company";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: true;
        isAutoincrement: true;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const companyTableUpdateSchema: z.ZodObject<{
    dni: z.ZodOptional<z.ZodString>;
    socialReason: z.ZodOptional<z.ZodString>;
    checkTender: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    id: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
}, "strip", z.ZodTypeAny, {
    id?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    dni?: string | undefined;
    socialReason?: string | undefined;
    deletedAt?: Date | null | undefined;
    checkTender?: boolean | undefined;
}, {
    id?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    dni?: string | undefined;
    socialReason?: string | undefined;
    deletedAt?: Date | null | undefined;
    checkTender?: boolean | undefined;
}>;
export declare const companyTableSelectSchema: z.ZodObject<Pick<{
    dni: z.ZodString;
    socialReason: z.ZodString;
    checkTender: z.ZodBoolean;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    id: z.ZodNumber;
}, "id" | "dni" | "socialReason" | "checkTender">, "strip", z.ZodTypeAny, {
    id: number;
    dni: string;
    socialReason: string;
    checkTender: boolean;
}, {
    id: number;
    dni: string;
    socialReason: string;
    checkTender: boolean;
}>;
export declare const userCompanyTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    userId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "user_id";
        tableName: "user_company";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: true;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    companyId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "company_id";
        tableName: "user_company";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: true;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const userCompanyTableUpdateSchema: z.ZodObject<{
    userId: z.ZodOptional<z.ZodNumber>;
    companyId: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    companyId?: number | undefined;
    userId?: number | undefined;
}, {
    companyId?: number | undefined;
    userId?: number | undefined;
}>;
export declare const userCompanyTableSelectSchema: z.ZodObject<Pick<{
    userId: z.ZodNumber;
    companyId: z.ZodNumber;
}, "companyId" | "userId">, "strip", z.ZodTypeAny, {
    companyId: number;
    userId: number;
}, {
    companyId: number;
    userId: number;
}>;
export declare const keywordTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    value: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "value";
        tableName: "keyword";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    codeCategoriaMercadoPublico: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "code_categoria_mercado_publico";
        tableName: "keyword";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    origin: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "origin";
        tableName: "keyword";
        dataType: "string";
        columnType: "MySqlEnumColumn";
        data: KeywordOrigin;
        driverParam: string;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [KeywordOrigin.MERCADO_PUBLICO, KeywordOrigin.USER, KeywordOrigin.ADMIN];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {
        $type: KeywordOrigin;
    }>;
    metadata: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "metadata";
        tableName: "keyword";
        dataType: "json";
        columnType: "MySqlJson";
        data: Metadata;
        driverParam: string;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {
        $type: Metadata;
    }>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "keyword";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "keyword";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "keyword";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "keyword";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    id: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "id";
        tableName: "keyword";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: true;
        isAutoincrement: true;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const keywordTableUpdateSchema: z.ZodObject<{
    value: z.ZodOptional<z.ZodString>;
    codeCategoriaMercadoPublico: z.ZodOptional<z.ZodNumber>;
    origin: z.ZodOptional<z.ZodOptional<z.ZodEnum<[KeywordOrigin.MERCADO_PUBLICO, KeywordOrigin.USER, KeywordOrigin.ADMIN]>>>;
    metadata: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodType<Metadata, z.ZodTypeDef, Metadata>>>>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    id: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
}, "strip", z.ZodTypeAny, {
    id?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    value?: string | undefined;
    metadata?: Metadata | null | undefined;
    codeCategoriaMercadoPublico?: number | undefined;
    origin?: KeywordOrigin | undefined;
    deletedAt?: Date | null | undefined;
}, {
    id?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    value?: string | undefined;
    metadata?: Metadata | null | undefined;
    codeCategoriaMercadoPublico?: number | undefined;
    origin?: KeywordOrigin | undefined;
    deletedAt?: Date | null | undefined;
}>;
export declare const keywordTableSelectSchema: z.ZodObject<Pick<{
    value: z.ZodString;
    codeCategoriaMercadoPublico: z.ZodNumber;
    origin: z.ZodEnum<[KeywordOrigin.MERCADO_PUBLICO, KeywordOrigin.USER, KeywordOrigin.ADMIN]>;
    metadata: z.ZodNullable<z.ZodType<Metadata, z.ZodTypeDef, Metadata>>;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    id: z.ZodNumber;
}, "id" | "value" | "codeCategoriaMercadoPublico" | "origin">, "strip", z.ZodTypeAny, {
    id: number;
    value: string;
    codeCategoriaMercadoPublico: number;
    origin: KeywordOrigin;
}, {
    id: number;
    value: string;
    codeCategoriaMercadoPublico: number;
    origin: KeywordOrigin;
}>;
export declare const userCompanyTenderTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    isFavorite: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "is_favorite";
        tableName: "user_company_tender";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    source: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "source";
        tableName: "user_company_tender";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    matchResult: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "match_result";
        tableName: "user_company_tender";
        dataType: "string";
        columnType: "MySqlText";
        data: string;
        driverParam: string;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "user_company_tender";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "user_company_tender";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "user_company_tender";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "user_company_tender";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    userId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "user_id";
        tableName: "user_company_tender";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: true;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    companyId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "company_id";
        tableName: "user_company_tender";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: true;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    tenderId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "tender_id";
        tableName: "user_company_tender";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: true;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const userCompanyTenderTableUpdateSchema: z.ZodObject<{
    isFavorite: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    source: z.ZodOptional<z.ZodString>;
    matchResult: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodString>>>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    userId: z.ZodOptional<z.ZodNumber>;
    companyId: z.ZodOptional<z.ZodNumber>;
    tenderId: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    companyId?: number | undefined;
    tenderId?: number | undefined;
    userId?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    isFavorite?: boolean | undefined;
    source?: string | undefined;
    matchResult?: string | null | undefined;
    deletedAt?: Date | null | undefined;
}, {
    companyId?: number | undefined;
    tenderId?: number | undefined;
    userId?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    isFavorite?: boolean | undefined;
    source?: string | undefined;
    matchResult?: string | null | undefined;
    deletedAt?: Date | null | undefined;
}>;
export declare const userCompanyTenderTableSelectSchema: z.ZodObject<Pick<{
    isFavorite: z.ZodBoolean;
    source: z.ZodString;
    matchResult: z.ZodNullable<z.ZodString>;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    userId: z.ZodNumber;
    companyId: z.ZodNumber;
    tenderId: z.ZodNumber;
}, "companyId" | "tenderId" | "userId" | "isFavorite" | "source" | "matchResult">, "strip", z.ZodTypeAny, {
    companyId: number;
    tenderId: number;
    userId: number;
    isFavorite: boolean;
    source: string;
    matchResult: string | null;
}, {
    companyId: number;
    tenderId: number;
    userId: number;
    isFavorite: boolean;
    source: string;
    matchResult: string | null;
}>;
export declare const userCompanyAgileTenderTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    isFavorite: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "is_favorite";
        tableName: "user_company_agile_tender";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    matchResult: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "match_result";
        tableName: "user_company_agile_tender";
        dataType: "string";
        columnType: "MySqlText";
        data: string;
        driverParam: string;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "user_company_agile_tender";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "user_company_agile_tender";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "user_company_agile_tender";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "user_company_agile_tender";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    userId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "user_id";
        tableName: "user_company_agile_tender";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: true;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    companyId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "company_id";
        tableName: "user_company_agile_tender";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: true;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    agileTenderId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "agile_tender_id";
        tableName: "user_company_agile_tender";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: true;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const userCompanyAgileTenderTableUpdateSchema: z.ZodObject<{
    isFavorite: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    matchResult: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodString>>>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    userId: z.ZodOptional<z.ZodNumber>;
    companyId: z.ZodOptional<z.ZodNumber>;
    agileTenderId: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    companyId?: number | undefined;
    userId?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    isFavorite?: boolean | undefined;
    matchResult?: string | null | undefined;
    agileTenderId?: number | undefined;
    deletedAt?: Date | null | undefined;
}, {
    companyId?: number | undefined;
    userId?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    isFavorite?: boolean | undefined;
    matchResult?: string | null | undefined;
    agileTenderId?: number | undefined;
    deletedAt?: Date | null | undefined;
}>;
export declare const userCompanyAgileTenderTableSelectSchema: z.ZodObject<Pick<{
    isFavorite: z.ZodBoolean;
    matchResult: z.ZodNullable<z.ZodString>;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    userId: z.ZodNumber;
    companyId: z.ZodNumber;
    agileTenderId: z.ZodNumber;
}, "companyId" | "userId" | "isFavorite" | "matchResult" | "agileTenderId">, "strip", z.ZodTypeAny, {
    companyId: number;
    userId: number;
    isFavorite: boolean;
    matchResult: string | null;
    agileTenderId: number;
}, {
    companyId: number;
    userId: number;
    isFavorite: boolean;
    matchResult: string | null;
    agileTenderId: number;
}>;
export declare const userHistoryTenderTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    userId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "user_id";
        tableName: "user_history_tender";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    tenderId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "tender_id";
        tableName: "user_history_tender";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    codeTender: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "code_tender";
        tableName: "user_history_tender";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    metadata: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "metadata";
        tableName: "user_history_tender";
        dataType: "json";
        columnType: "MySqlJson";
        data: HistoryMetadata;
        driverParam: string;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {
        $type: HistoryMetadata;
    }>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "user_history_tender";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "user_history_tender";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "user_history_tender";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "user_history_tender";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    id: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "id";
        tableName: "user_history_tender";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: true;
        isAutoincrement: true;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const userHistoryTenderTableUpdateSchema: z.ZodObject<{
    userId: z.ZodOptional<z.ZodNumber>;
    tenderId: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodNumber>>>;
    codeTender: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodString>>>;
    metadata: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodType<HistoryMetadata, z.ZodTypeDef, HistoryMetadata>>>>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    id: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
}, "strip", z.ZodTypeAny, {
    id?: number | undefined;
    tenderId?: number | null | undefined;
    userId?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    metadata?: HistoryMetadata | null | undefined;
    deletedAt?: Date | null | undefined;
    codeTender?: string | null | undefined;
}, {
    id?: number | undefined;
    tenderId?: number | null | undefined;
    userId?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    metadata?: HistoryMetadata | null | undefined;
    deletedAt?: Date | null | undefined;
    codeTender?: string | null | undefined;
}>;
export declare const userHistoryTenderTableSelectSchema: z.ZodObject<Pick<{
    userId: z.ZodNumber;
    tenderId: z.ZodNullable<z.ZodNumber>;
    codeTender: z.ZodNullable<z.ZodString>;
    metadata: z.ZodNullable<z.ZodType<HistoryMetadata, z.ZodTypeDef, HistoryMetadata>>;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    id: z.ZodNumber;
}, "tenderId" | "userId">, "strip", z.ZodTypeAny, {
    tenderId: number | null;
    userId: number;
}, {
    tenderId: number | null;
    userId: number;
}>;
export declare const tenderTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    closeDate: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "close_date";
        tableName: "tender";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    code: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "code";
        tableName: "tender";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    name: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "name";
        tableName: "tender";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    description: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "description";
        tableName: "tender";
        dataType: "string";
        columnType: "MySqlText";
        data: string;
        driverParam: string;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    subdivisionId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "subdivision_id";
        tableName: "tender";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    details: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "details";
        tableName: "tender";
        dataType: "json";
        columnType: "MySqlJson";
        data: Licitacion;
        driverParam: string;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {
        $type: Licitacion;
    }>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "tender";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "tender";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "tender";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "tender";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    id: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "id";
        tableName: "tender";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: true;
        isAutoincrement: true;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, {
    details: z.ZodAny;
}>;
export declare const tenderTableUpdateSchema: z.ZodObject<{
    closeDate: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    code: z.ZodOptional<z.ZodString>;
    name: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    subdivisionId: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodNumber>>>;
    details: z.ZodOptional<z.ZodAny>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    id: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
}, "strip", z.ZodTypeAny, {
    name?: string | undefined;
    description?: string | undefined;
    id?: number | undefined;
    code?: string | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    subdivisionId?: number | null | undefined;
    active?: boolean | undefined;
    details?: any;
    closeDate?: Date | null | undefined;
    deletedAt?: Date | null | undefined;
}, {
    name?: string | undefined;
    description?: string | undefined;
    id?: number | undefined;
    code?: string | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    subdivisionId?: number | null | undefined;
    active?: boolean | undefined;
    details?: any;
    closeDate?: Date | null | undefined;
    deletedAt?: Date | null | undefined;
}>;
export declare const tenderTableSelectSchema: z.ZodObject<Pick<{
    closeDate: z.ZodNullable<z.ZodDate>;
    code: z.ZodString;
    name: z.ZodString;
    description: z.ZodString;
    subdivisionId: z.ZodNullable<z.ZodNumber>;
    details: z.ZodType<Licitacion, z.ZodTypeDef, Licitacion>;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    id: z.ZodNumber;
}, "name" | "description" | "id" | "code" | "subdivisionId" | "details">, "strip", z.ZodTypeAny, {
    name: string;
    description: string;
    id: number;
    code: string;
    subdivisionId: number | null;
    details: Licitacion;
}, {
    name: string;
    description: string;
    id: number;
    code: string;
    subdivisionId: number | null;
    details: Licitacion;
}>;
export declare const agileTenderTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    closeDate: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "close_date";
        tableName: "tender_agile";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    code: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "code";
        tableName: "tender_agile";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    name: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "name";
        tableName: "tender_agile";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    description: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "description";
        tableName: "tender_agile";
        dataType: "string";
        columnType: "MySqlText";
        data: string;
        driverParam: string;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    descriptionLocation: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "description_location";
        tableName: "tender_agile";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    details: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "details";
        tableName: "tender_agile";
        dataType: "json";
        columnType: "MySqlJson";
        data: AgileTenderFullInfoTO;
        driverParam: string;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {
        $type: AgileTenderFullInfoTO;
    }>;
    subdivisionId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "subdivision_id";
        tableName: "tender_agile";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    amountCLP: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "amount_clp";
        tableName: "tender_agile";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "tender_agile";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "tender_agile";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "tender_agile";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "tender_agile";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    id: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "id";
        tableName: "tender_agile";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: true;
        isAutoincrement: true;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, {
    details: z.ZodAny;
}>;
export declare const agileTenderTableUpdateSchema: z.ZodObject<{
    closeDate: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    code: z.ZodOptional<z.ZodString>;
    name: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    descriptionLocation: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodString>>>;
    details: z.ZodOptional<z.ZodAny>;
    subdivisionId: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodNumber>>>;
    amountCLP: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodNumber>>>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    id: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
}, "strip", z.ZodTypeAny, {
    name?: string | undefined;
    description?: string | undefined;
    id?: number | undefined;
    code?: string | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    subdivisionId?: number | null | undefined;
    active?: boolean | undefined;
    details?: any;
    closeDate?: Date | null | undefined;
    descriptionLocation?: string | null | undefined;
    amountCLP?: number | null | undefined;
    deletedAt?: Date | null | undefined;
}, {
    name?: string | undefined;
    description?: string | undefined;
    id?: number | undefined;
    code?: string | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    subdivisionId?: number | null | undefined;
    active?: boolean | undefined;
    details?: any;
    closeDate?: Date | null | undefined;
    descriptionLocation?: string | null | undefined;
    amountCLP?: number | null | undefined;
    deletedAt?: Date | null | undefined;
}>;
export declare const agileTenderTableSelectSchema: z.ZodObject<Pick<{
    closeDate: z.ZodNullable<z.ZodDate>;
    code: z.ZodString;
    name: z.ZodString;
    description: z.ZodString;
    descriptionLocation: z.ZodNullable<z.ZodString>;
    details: z.ZodType<AgileTenderFullInfoTO, z.ZodTypeDef, AgileTenderFullInfoTO>;
    subdivisionId: z.ZodNullable<z.ZodNumber>;
    amountCLP: z.ZodNullable<z.ZodNumber>;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    id: z.ZodNumber;
}, "name" | "description" | "id" | "code" | "details" | "closeDate" | "descriptionLocation" | "amountCLP">, "strip", z.ZodTypeAny, {
    name: string;
    description: string;
    id: number;
    code: string;
    details: AgileTenderFullInfoTO;
    closeDate: Date | null;
    descriptionLocation: string | null;
    amountCLP: number | null;
}, {
    name: string;
    description: string;
    id: number;
    code: string;
    details: AgileTenderFullInfoTO;
    closeDate: Date | null;
    descriptionLocation: string | null;
    amountCLP: number | null;
}>;
export declare const userDeviceTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    userId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "user_id";
        tableName: "user_device";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    token: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "token";
        tableName: "user_device";
        dataType: "string";
        columnType: "MySqlText";
        data: string;
        driverParam: string;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    information: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "information";
        tableName: "user_device";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "user_device";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "user_device";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "user_device";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "user_device";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    id: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "id";
        tableName: "user_device";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: true;
        isAutoincrement: true;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const userDeviceTableUpdateSchema: z.ZodObject<{
    userId: z.ZodOptional<z.ZodNumber>;
    token: z.ZodOptional<z.ZodString>;
    information: z.ZodOptional<z.ZodString>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    id: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
}, "strip", z.ZodTypeAny, {
    id?: number | undefined;
    userId?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    token?: string | undefined;
    information?: string | undefined;
    deletedAt?: Date | null | undefined;
}, {
    id?: number | undefined;
    userId?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    token?: string | undefined;
    information?: string | undefined;
    deletedAt?: Date | null | undefined;
}>;
export declare const userDeviceTableSelectSchema: z.ZodObject<Pick<{
    userId: z.ZodNumber;
    token: z.ZodString;
    information: z.ZodString;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    id: z.ZodNumber;
}, "id" | "userId" | "token">, "strip", z.ZodTypeAny, {
    id: number;
    userId: number;
    token: string;
}, {
    id: number;
    userId: number;
    token: string;
}>;
export declare const userRequestTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    userId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "user_id";
        tableName: "user_request";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    companyId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "company_id";
        tableName: "user_request";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    stateRequestTypeId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "state_request_type_id";
        tableName: "user_request";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    title: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "title";
        tableName: "user_request";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    description: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "description";
        tableName: "user_request";
        dataType: "string";
        columnType: "MySqlText";
        data: string;
        driverParam: string;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    tenderId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "tender_id";
        tableName: "user_request";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "user_request";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "user_request";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "user_request";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "user_request";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    id: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "id";
        tableName: "user_request";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: true;
        isAutoincrement: true;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const userRequestTableUpdateSchema: z.ZodObject<{
    userId: z.ZodOptional<z.ZodNumber>;
    companyId: z.ZodOptional<z.ZodNumber>;
    stateRequestTypeId: z.ZodOptional<z.ZodNumber>;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    tenderId: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodNumber>>>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    id: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
}, "strip", z.ZodTypeAny, {
    description?: string | undefined;
    title?: string | undefined;
    id?: number | undefined;
    companyId?: number | undefined;
    tenderId?: number | null | undefined;
    userId?: number | undefined;
    stateRequestTypeId?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    deletedAt?: Date | null | undefined;
}, {
    description?: string | undefined;
    title?: string | undefined;
    id?: number | undefined;
    companyId?: number | undefined;
    tenderId?: number | null | undefined;
    userId?: number | undefined;
    stateRequestTypeId?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    deletedAt?: Date | null | undefined;
}>;
export declare const userRequestTableSelectSchema: z.ZodObject<Pick<{
    userId: z.ZodNumber;
    companyId: z.ZodNumber;
    stateRequestTypeId: z.ZodNumber;
    title: z.ZodString;
    description: z.ZodString;
    tenderId: z.ZodNullable<z.ZodNumber>;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    id: z.ZodNumber;
}, "id" | "companyId" | "tenderId" | "userId" | "stateRequestTypeId">, "strip", z.ZodTypeAny, {
    id: number;
    companyId: number;
    tenderId: number | null;
    userId: number;
    stateRequestTypeId: number;
}, {
    id: number;
    companyId: number;
    tenderId: number | null;
    userId: number;
    stateRequestTypeId: number;
}>;
export declare const userCampaignTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    description: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "description";
        tableName: "user_campaign";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    title: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "title";
        tableName: "user_campaign";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    defaultMessage: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "default_message";
        tableName: "user_campaign";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    dayOfWeek: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "day_of_week";
        tableName: "user_campaign";
        dataType: "string";
        columnType: "MySqlVarChar";
        data: string;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    defHour: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "def_hour";
        tableName: "user_campaign";
        dataType: "number";
        columnType: "MySqlSmallInt";
        data: number;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    defMinute: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "def_minute";
        tableName: "user_campaign";
        dataType: "number";
        columnType: "MySqlSmallInt";
        data: number;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "user_campaign";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "user_campaign";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "user_campaign";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "user_campaign";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    id: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "id";
        tableName: "user_campaign";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: true;
        isAutoincrement: true;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const userCampaignTableUpdateSchema: z.ZodObject<{
    description: z.ZodOptional<z.ZodString>;
    title: z.ZodOptional<z.ZodString>;
    defaultMessage: z.ZodOptional<z.ZodString>;
    dayOfWeek: z.ZodOptional<z.ZodString>;
    defHour: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodNumber>>>;
    defMinute: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodNumber>>>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    id: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
}, "strip", z.ZodTypeAny, {
    description?: string | undefined;
    title?: string | undefined;
    id?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    defaultMessage?: string | undefined;
    active?: boolean | undefined;
    dayOfWeek?: string | undefined;
    defHour?: number | null | undefined;
    defMinute?: number | null | undefined;
    deletedAt?: Date | null | undefined;
}, {
    description?: string | undefined;
    title?: string | undefined;
    id?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    defaultMessage?: string | undefined;
    active?: boolean | undefined;
    dayOfWeek?: string | undefined;
    defHour?: number | null | undefined;
    defMinute?: number | null | undefined;
    deletedAt?: Date | null | undefined;
}>;
export declare const userCampaignTableSelectSchema: z.ZodObject<Pick<{
    description: z.ZodString;
    title: z.ZodString;
    defaultMessage: z.ZodString;
    dayOfWeek: z.ZodString;
    defHour: z.ZodNullable<z.ZodNumber>;
    defMinute: z.ZodNullable<z.ZodNumber>;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    id: z.ZodNumber;
}, "description" | "title" | "id" | "defaultMessage" | "dayOfWeek" | "defHour" | "defMinute">, "strip", z.ZodTypeAny, {
    description: string;
    title: string;
    id: number;
    defaultMessage: string;
    dayOfWeek: string;
    defHour: number | null;
    defMinute: number | null;
}, {
    description: string;
    title: string;
    id: number;
    defaultMessage: string;
    dayOfWeek: string;
    defHour: number | null;
    defMinute: number | null;
}>;
export declare const matchingWordTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    coincidence: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "coincidence";
        tableName: "matching_word";
        dataType: "json";
        columnType: "MySqlJson";
        data: MatchWordTO;
        driverParam: string;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {
        $type: MatchWordTO;
    }>;
    subdivisionId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "subdivision_id";
        tableName: "matching_word";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "matching_word";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "matching_word";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "matching_word";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "matching_word";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    id: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "id";
        tableName: "matching_word";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: true;
        isAutoincrement: true;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const matchingWordTableUpdateSchema: z.ZodObject<{
    coincidence: z.ZodOptional<z.ZodType<MatchWordTO, z.ZodTypeDef, MatchWordTO>>;
    subdivisionId: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodNumber>>>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    id: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
}, "strip", z.ZodTypeAny, {
    id?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    subdivisionId?: number | null | undefined;
    active?: boolean | undefined;
    coincidence?: MatchWordTO | undefined;
    deletedAt?: Date | null | undefined;
}, {
    id?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    subdivisionId?: number | null | undefined;
    active?: boolean | undefined;
    coincidence?: MatchWordTO | undefined;
    deletedAt?: Date | null | undefined;
}>;
export declare const matchingWordTableSelectSchema: z.ZodObject<Pick<{
    coincidence: z.ZodType<MatchWordTO, z.ZodTypeDef, MatchWordTO>;
    subdivisionId: z.ZodNullable<z.ZodNumber>;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    id: z.ZodNumber;
}, "id" | "subdivisionId" | "coincidence">, "strip", z.ZodTypeAny, {
    id: number;
    subdivisionId: number | null;
    coincidence: MatchWordTO;
}, {
    id: number;
    subdivisionId: number | null;
    coincidence: MatchWordTO;
}>;
export declare const tenderKeywordCategoryTableInsertSchema: import("drizzle-zod").BuildSchema<"insert", {
    agileTenderId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "agile_tender_id";
        tableName: "tender_keyword_category";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    normalTenderId: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "normal_tender_id";
        tableName: "tender_keyword_category";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    codeMercadoPublico: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "code_mercado_publico";
        tableName: "tender_keyword_category";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    itemDescription: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "item_description";
        tableName: "tender_keyword_category";
        dataType: "string";
        columnType: "MySqlText";
        data: string;
        driverParam: string;
        notNull: true;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: [string, ...string[]];
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    createdAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "created_at";
        tableName: "tender_keyword_category";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    updatedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "updated_at";
        tableName: "tender_keyword_category";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    deletedAt: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "deleted_at";
        tableName: "tender_keyword_category";
        dataType: "date";
        columnType: "MySqlTimestamp";
        data: Date;
        driverParam: string | number;
        notNull: false;
        hasDefault: false;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    active: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "active";
        tableName: "tender_keyword_category";
        dataType: "boolean";
        columnType: "MySqlBoolean";
        data: boolean;
        driverParam: number | boolean;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: false;
        isAutoincrement: false;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
    id: import("drizzle-orm/mysql-core").MySqlColumn<{
        name: "id";
        tableName: "tender_keyword_category";
        dataType: "number";
        columnType: "MySqlBigInt53";
        data: number;
        driverParam: string | number;
        notNull: true;
        hasDefault: true;
        isPrimaryKey: true;
        isAutoincrement: true;
        hasRuntimeDefault: false;
        enumValues: undefined;
        baseColumn: never;
        identity: undefined;
        generated: undefined;
    }, {}, {}>;
}, undefined>;
export declare const tenderKeywordCategoryTableUpdateSchema: z.ZodObject<{
    agileTenderId: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodNumber>>>;
    normalTenderId: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodNumber>>>;
    codeMercadoPublico: z.ZodOptional<z.ZodNumber>;
    itemDescription: z.ZodOptional<z.ZodString>;
    createdAt: z.ZodOptional<z.ZodOptional<z.ZodDate>>;
    updatedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    deletedAt: z.ZodOptional<z.ZodOptional<z.ZodNullable<z.ZodDate>>>;
    active: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    id: z.ZodOptional<z.ZodOptional<z.ZodNumber>>;
}, "strip", z.ZodTypeAny, {
    id?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    codeMercadoPublico?: number | undefined;
    itemDescription?: string | undefined;
    agileTenderId?: number | null | undefined;
    normalTenderId?: number | null | undefined;
    deletedAt?: Date | null | undefined;
}, {
    id?: number | undefined;
    createdAt?: Date | undefined;
    updatedAt?: Date | null | undefined;
    active?: boolean | undefined;
    codeMercadoPublico?: number | undefined;
    itemDescription?: string | undefined;
    agileTenderId?: number | null | undefined;
    normalTenderId?: number | null | undefined;
    deletedAt?: Date | null | undefined;
}>;
export declare const tenderKeywordCategoryTableSelectSchema: z.ZodObject<Pick<{
    agileTenderId: z.ZodNullable<z.ZodNumber>;
    normalTenderId: z.ZodNullable<z.ZodNumber>;
    codeMercadoPublico: z.ZodNumber;
    itemDescription: z.ZodString;
    createdAt: z.ZodDate;
    updatedAt: z.ZodNullable<z.ZodDate>;
    deletedAt: z.ZodNullable<z.ZodDate>;
    active: z.ZodBoolean;
    id: z.ZodNumber;
}, "id" | "codeMercadoPublico" | "itemDescription" | "agileTenderId" | "normalTenderId">, "strip", z.ZodTypeAny, {
    id: number;
    codeMercadoPublico: number;
    itemDescription: string;
    agileTenderId: number | null;
    normalTenderId: number | null;
}, {
    id: number;
    codeMercadoPublico: number;
    itemDescription: string;
    agileTenderId: number | null;
    normalTenderId: number | null;
}>;
