import { GeoRepository } from 'src/framework/application/repository/geo-repository/geo-repository.interface';
import { AdministrativeDivision, Country } from 'src/framework/domain';
import { DBConfigService } from 'src/framework/infrastructure/drizzle/drizzle.provider';
import { Subdivision } from 'src/framework/domain/entities/subdivision.entity';
export declare class GeoRepositoryImpl implements GeoRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    getAllAdministrativeDivisions(): Promise<AdministrativeDivision[]>;
    getAllSubdivisions(): Promise<Subdivision[]>;
    findCountries(): Promise<Country[]>;
    findCountryById(id: number): Promise<Country | null>;
    findSubdivisionsByCountryCode(countryCode: string): Promise<Subdivision[]>;
    findAdmdivisionsBySubdivisionCode(subdivisionCode: number): Promise<AdministrativeDivision[]>;
    findAdmdivisionsByCountry(prefixCode: string): Promise<AdministrativeDivision[]>;
}
