import { NotificationRecordRepository } from 'src/framework/application/repository/notification-record-repository/notification-record-repository.interface';
import { NotificationRecord, InsertNotificationRecord, UpdateNotificationRecord } from 'src/framework/domain';
import { TxType } from '../../drizzle';
import { DBConfigService } from '../../drizzle/drizzle.provider';
export declare class NotificationRecordRepositoryImpl implements NotificationRecordRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    erraseNotificationRecordsByTender(tenderIds: number[], tx?: TxType): Promise<void>;
    markNotificationEmailAsSent(notificationRecordId: number[], tx?: TxType): Promise<void>;
    saveAll(notificationRecords: InsertNotificationRecord[], tx?: TxType): Promise<void>;
    updateNotification(notificationRecordId: number, notificationRecord: UpdateNotificationRecord, tx?: TxType): Promise<void>;
    getActiveNotificationRecords(userId: number, isAdmin?: boolean): Promise<NotificationRecord[]>;
    getNotificationRecordsPaginated(userId: number, page: number, pageSize: number): Promise<NotificationRecord[]>;
    logicalRemoveBYListId(ids: number[], tx?: TxType): Promise<void>;
    getAdminNotification(): Promise<NotificationRecord[]>;
    getUserNotificationRecordsActive(): Promise<NotificationRecord[]>;
}
