"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var RoleRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoleRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const domain_1 = require("../../../domain");
const drizzle_provider_1 = require("../../drizzle/drizzle.provider");
const schema = require("../../drizzle/migrations/schema");
const drizzle_orm_1 = require("drizzle-orm");
const definition_1 = require("../../definition");
let RoleRepositoryImpl = RoleRepositoryImpl_1 = class RoleRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new definition_1.PrimeLogger(RoleRepositoryImpl_1.name);
    }
    async getRoleByKey(shortName) {
        this.LOGGER.log(`getRoleByKey shortName ${shortName}`);
        return await this.db.conn
            .select({
            id: schema.roleTable.id,
            name: schema.roleTable.name,
            shortName: schema.roleTable.shortName,
        })
            .from(schema.roleTable)
            .where((0, drizzle_orm_1.eq)(schema.roleTable.shortName, shortName))
            .then((rows) => {
            if (rows.length === 0) {
                throw new Error(`Role with shortName ${shortName} not found`);
            }
            return new domain_1.Role(rows[0].id, rows[0].name, rows[0].shortName);
        });
    }
};
exports.RoleRepositoryImpl = RoleRepositoryImpl;
exports.RoleRepositoryImpl = RoleRepositoryImpl = RoleRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_provider_1.DBConfigService])
], RoleRepositoryImpl);
//# sourceMappingURL=role-repository-impl.js.map