"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var UserCampaignsRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserCampaignsRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const drizzle_provider_1 = require("../../drizzle/drizzle.provider");
const domain_1 = require("../../../domain");
const definition_1 = require("../../definition");
const util_1 = require("../../../../licitaapp/domain/util");
const drizzle_orm_1 = require("drizzle-orm");
const schema = require("../../drizzle/migrations/schema");
let UserCampaignsRepositoryImpl = UserCampaignsRepositoryImpl_1 = class UserCampaignsRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new definition_1.PrimeLogger(UserCampaignsRepositoryImpl_1.name);
    }
    getActiveCampaigns() {
        this.LOGGER.log('Getting active user campaigns...');
        const query = this.db.conn
            .select()
            .from(schema.userCampaignTable)
            .where((0, drizzle_orm_1.eq)(schema.userCampaignTable.active, true));
        return query;
    }
    async create(data) {
        this.LOGGER.log('Creating user campaign...');
        const validateUserCampaign = schema.userCampaignTableInsertSchema.parse(data);
        const userCampaignId = await (this.db.conn)
            .insert(schema.userCampaignTable)
            .values(validateUserCampaign)
            .$returningId()
            .then((rows) => {
            return rows[0].id;
        });
        return await this.findById(userCampaignId).then((object) => {
            if (object) {
                return object;
            }
            throw new Error('User campaign not found');
        });
    }
    async findById(id) {
        this.LOGGER.log(`Finding user campaign by ID: ${id}`);
        const selectFields = {
            id: schema.userCampaignTable.id,
            description: schema.userCampaignTable.description,
            title: schema.userCampaignTable.title,
            dayOfWeek: schema.userCampaignTable.dayOfWeek,
            minute: schema.userCampaignTable.defMinute,
            hour: schema.userCampaignTable.defHour,
            defaultMessage: schema.userCampaignTable.defaultMessage,
        };
        const query = this.db.conn
            .select(selectFields)
            .from(schema.userCampaignTable)
            .where((0, drizzle_orm_1.eq)(schema.userCampaignTable.id, id));
        const rows = await query;
        if (rows.length === 0) {
            return null;
        }
        const row = rows[0];
        const record = new domain_1.UserCampaign();
        record.id = row.id;
        record.description = row.description;
        record.title = row.title;
        record.dayOfWeek = row.dayOfWeek;
        record.defMinute = row.minute;
        record.defHour = row.hour;
        record.defaultMessage = row.defaultMessage;
        return record;
    }
    async update(data) {
        this.LOGGER.log('Updating user campaign...');
        await this.db.conn
            .update(schema.userCampaignTable)
            .set({
            title: data.title,
            description: data.description,
            dayOfWeek: data.dayOfWeek,
            defMinute: data.defMinute,
            defHour: data.defHour,
            defaultMessage: data.defaultMessage,
            updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
        })
            .where((0, drizzle_orm_1.eq)(schema.userCampaignTable.id, data.id))
            .execute();
        return 'true';
    }
    async getPagination(page, pageSize, defaultMessageFilter) {
        this.LOGGER.log(`paginationTransferVehicle - page: ${page}, pageSize: ${pageSize}, defaultMessageFilter: ${defaultMessageFilter}`);
        const offset = (page - 1) * pageSize;
        const selectFields = {
            id: schema.userCampaignTable.id,
            description: schema.userCampaignTable.description,
            title: schema.userCampaignTable.title,
            dayOfWeek: schema.userCampaignTable.dayOfWeek,
            minute: schema.userCampaignTable.defMinute,
            hour: schema.userCampaignTable.defHour,
            defaultMessage: schema.userCampaignTable.defaultMessage,
        };
        const query = this.db.conn
            .select(selectFields)
            .from(schema.userCampaignTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(schema.userCampaignTable.active, true)))
            .limit(Number(pageSize))
            .offset(offset);
        const rows = await query;
        if (rows.length === 0) {
            return [];
        }
        return rows.map((row) => {
            const record = new domain_1.UserCampaign();
            record.id = row.id;
            record.description = row.description;
            record.title = row.title;
            record.dayOfWeek = row.dayOfWeek;
            record.defMinute = row.minute;
            record.defHour = row.hour;
            record.defaultMessage = row.defaultMessage;
            return record;
        });
    }
    logicalRemove(campaignId) {
        this.LOGGER.log(`Logical removing user campaign with ID: ${campaignId}`);
        return this.db.conn
            .update(schema.userCampaignTable)
            .set({ active: false, deletedAt: util_1.TenderUtil.getCurrentSystemDate() })
            .where((0, drizzle_orm_1.eq)(schema.userCampaignTable.id, campaignId))
            .execute()
            .then(() => {
            this.LOGGER.log(`User campaign with ID: ${campaignId} logically removed`);
        });
    }
};
exports.UserCampaignsRepositoryImpl = UserCampaignsRepositoryImpl;
exports.UserCampaignsRepositoryImpl = UserCampaignsRepositoryImpl = UserCampaignsRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_provider_1.DBConfigService])
], UserCampaignsRepositoryImpl);
//# sourceMappingURL=user-campaigns-repository-impl.js.map