import { UserDeviceRepository } from 'src/framework/application/repository/user-device-repository/user-device-repository.interface';
import { DBConfigService } from 'src/framework/infrastructure/drizzle/drizzle.provider';
import { TxType } from '../../drizzle/drizzle.types';
import { UserRoleService } from 'src/framework/application';
import { InsertUserDevice, UserDevice } from 'src/framework/domain/entities/user-device.entity';
export declare class UserDeviceRepositoryImpl implements UserDeviceRepository {
    private readonly db;
    private readonly userRoleService;
    private readonly LOGGER;
    constructor(db: DBConfigService, userRoleService: UserRoleService);
    erraseByIds(ids: number[], tx?: TxType): Promise<void>;
    erraseUserDevice(token: string): Promise<void>;
    logicalRemoveById(id: number, tx?: TxType): Promise<void>;
    findByUserId(userId: number, tx?: TxType): Promise<string[]>;
    findUserWithToken(token: string, tx?: TxType): Promise<UserDevice[]>;
    getAdminUserDeviceTokens(): Promise<string[]>;
    private getDeviceInfo;
    findById(id: number, tx?: TxType): Promise<UserDevice | null | undefined>;
    save(userId: number, userDevice: InsertUserDevice, tx?: TxType): Promise<UserDevice>;
}
