"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var UserDeviceRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserDeviceRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const app_exception_logger_1 = require("../../definition/logger/app.exception.logger");
const drizzle_provider_1 = require("../../drizzle/drizzle.provider");
const schema = require("../../drizzle/migrations/schema");
const drizzle_orm_1 = require("drizzle-orm");
const util_1 = require("../../../../licitaapp/domain/util");
const user_device_entity_1 = require("../../../domain/entities/user-device.entity");
let UserDeviceRepositoryImpl = UserDeviceRepositoryImpl_1 = class UserDeviceRepositoryImpl {
    constructor(db, userRoleService) {
        this.db = db;
        this.userRoleService = userRoleService;
        this.LOGGER = new app_exception_logger_1.PrimeLogger(UserDeviceRepositoryImpl_1.name);
    }
    async erraseByIds(ids, tx) {
        this.LOGGER.log(`Erasing user devices with ids: ${ids.join(', ')}`);
        await (tx || this.db.conn)
            .delete(schema.userDeviceTable)
            .where((0, drizzle_orm_1.inArray)(schema.userDeviceTable.id, ids));
    }
    erraseUserDevice(token) {
        this.LOGGER.log(`Erasing user device with token: ${token}`);
        return this.db.conn
            .delete(schema.userDeviceTable)
            .where((0, drizzle_orm_1.eq)(schema.userDeviceTable.token, token))
            .then(() => {
            this.LOGGER.log(`User device with token: ${token} has been erased`);
        });
    }
    async logicalRemoveById(id, tx) {
        this.LOGGER.log(`Logically removing user device with id: ${id}`);
        await (tx || this.db.conn)
            .update(schema.userDeviceTable)
            .set({
            active: false,
            updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
            deletedAt: util_1.TenderUtil.getCurrentSystemDate(),
        })
            .where((0, drizzle_orm_1.eq)(schema.userDeviceTable.id, id));
        this.LOGGER.log(`User device with id: ${id} has been logically removed`);
    }
    async findByUserId(userId, tx) {
        this.LOGGER.log(`Finding user device for user id: ${userId}`);
        return await (tx || this.db.conn)
            .select({
            id: schema.userDeviceTable.id,
            userId: schema.userDeviceTable.userId,
            token: schema.userDeviceTable.token,
            information: schema.userDeviceTable.information,
        })
            .from(schema.userDeviceTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(schema.userDeviceTable.active, true), (0, drizzle_orm_1.eq)(schema.userDeviceTable.userId, userId)))
            .then((rows) => {
            this.LOGGER.log(`Found ${rows.length} userDevices for user id: ${userId}`);
            return rows.map((row) => row.token);
        });
    }
    async findUserWithToken(token, tx) {
        this.LOGGER.log(`Finding findUserWithToken device by token: ${token}`);
        const results = [];
        await (tx || this.db.conn)
            .select({
            id: schema.userDeviceTable.id,
            userId: schema.userDeviceTable.userId,
            token: schema.userDeviceTable.token,
            information: schema.userDeviceTable.information,
        })
            .from(schema.userDeviceTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(schema.userDeviceTable.active, true), (0, drizzle_orm_1.eq)(schema.userDeviceTable.token, token)))
            .then((rows) => {
            if (rows.length === 0) {
                return null;
            }
            results.push(new user_device_entity_1.UserDevice(rows[0].id, rows[0].userId, rows[0].token, rows[0].information));
        });
        return results;
    }
    async getAdminUserDeviceTokens() {
        this.LOGGER.log(`Finding user device as admin token `);
        const userIds = await this.userRoleService.getAdminUserIds();
        this.LOGGER.warn(`userIds SIZE: ${userIds.length}`);
        return await this.db.conn
            .select({
            token: schema.userDeviceTable.token,
        })
            .from(schema.userDeviceTable)
            .innerJoin(schema.userTable, (0, drizzle_orm_1.eq)(schema.userDeviceTable.userId, schema.userTable.id))
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(schema.userDeviceTable.active, true), (0, drizzle_orm_1.inArray)(schema.userDeviceTable.userId, userIds)))
            .then((rows) => {
            return rows.map((row) => row.token);
        });
    }
    getDeviceInfo(deviceInfo) {
        const parts = deviceInfo.split(';');
        return {
            model: parts[0] || '',
            idPhone: parts[parts.length - 1] || '',
        };
    }
    async findById(id, tx) {
        this.LOGGER.log(`Finding user device by userId: ${id}`);
        return await (tx || this.db.conn)
            .select({
            id: schema.userDeviceTable.id,
            userId: schema.userDeviceTable.userId,
            token: schema.userDeviceTable.token,
            information: schema.userDeviceTable.information,
        })
            .from(schema.userDeviceTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(schema.userDeviceTable.active, true), (0, drizzle_orm_1.eq)(schema.userDeviceTable.id, id)))
            .then((rows) => {
            if (rows.length === 0) {
                this.LOGGER.log(`No user device found with id: ${id}`);
                return null;
            }
            this.LOGGER.log(`Found user device with id: ${id}`);
            return new user_device_entity_1.UserDevice(rows[0].id, rows[0].userId, rows[0].token, rows[0].information);
        });
    }
    async save(userId, userDevice, tx) {
        this.LOGGER.log(`Saving user device for user id: ${userId}`);
        await (tx || this.db.conn)
            .delete(schema.userDeviceTable)
            .where((0, drizzle_orm_1.eq)(schema.userDeviceTable.token, userDevice.token));
        userDevice.userId = userId;
        const validatedUserDevice = schema.userDeviceTableInsertSchema.parse(userDevice);
        const insertedUserDeviceId = await (tx || this.db.conn)
            .insert(schema.userDeviceTable)
            .values(validatedUserDevice)
            .$returningId()
            .then((rows) => {
            this.LOGGER.log(`Inserted User Device with id: ${rows[0].id}`);
            return rows[0].id;
        });
        return await this.findById(insertedUserDeviceId).then((userDevice) => {
            if (userDevice) {
                this.LOGGER.log(`User device saved successfully with id: ${userDevice.id}`);
                return userDevice;
            }
            else {
                this.LOGGER.error('UserDevice not found after save');
                throw new Error('UserDevice not found');
            }
        });
    }
};
exports.UserDeviceRepositoryImpl = UserDeviceRepositoryImpl;
exports.UserDeviceRepositoryImpl = UserDeviceRepositoryImpl = UserDeviceRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, common_1.Inject)('UserRoleService')),
    __metadata("design:paramtypes", [drizzle_provider_1.DBConfigService, Object])
], UserDeviceRepositoryImpl);
//# sourceMappingURL=user-device-repository-impl.js.map