"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var UserRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const domain_1 = require("../../../domain");
const drizzle_provider_1 = require("../../drizzle/drizzle.provider");
const schema = require("../../drizzle/migrations/schema");
const drizzle_orm_1 = require("drizzle-orm");
const app_exception_logger_1 = require("../../definition/logger/app.exception.logger");
const util_1 = require("../../../../licitaapp/domain/util");
let UserRepositoryImpl = UserRepositoryImpl_1 = class UserRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new app_exception_logger_1.PrimeLogger(UserRepositoryImpl_1.name);
    }
    async findAll() {
        this.LOGGER.log('Finding all users');
        return await this.db.conn
            .select({
            id: schema.userTable.id,
            name: schema.userTable.name,
            email: schema.userTable.email,
            lastName: schema.userTable.lastName,
            lastname2: schema.userTable.lastname2,
            cellPhone: schema.userTable.cellPhone,
        })
            .from(schema.userTable)
            .then((rows) => {
            this.LOGGER.log(`Found ${rows.length} users`);
            return rows.map((row) => new domain_1.User(row.id, row.name, row.email, row.lastName, row.lastname2, row.cellPhone));
        });
    }
    async updateLastLogin(userId) {
        this.LOGGER.log(`Updating last login for user with id: ${userId}`);
        await this.db.conn
            .update(schema.userTable)
            .set({ lastAccess: util_1.TenderUtil.getCurrentSystemDate() })
            .where((0, drizzle_orm_1.eq)(schema.userTable.id, userId));
    }
    async findEmailsAdmin(userIds) {
        this.LOGGER.log('Finding all users actives admin');
        return await this.db.conn
            .select({
            email: schema.userTable.email,
        })
            .from(schema.userTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.inArray)(schema.userTable.id, userIds), (0, drizzle_orm_1.eq)(schema.userTable.active, true)))
            .then((rows) => {
            this.LOGGER.log(`Found ${rows.length} users`);
            return rows.map((row) => row.email);
        });
    }
    async findByEmail(email) {
        this.LOGGER.log(`Finding user by email: ${email}`);
        return await this.db.conn
            .select({
            id: schema.userTable.id,
            name: schema.userTable.name,
            email: schema.userTable.email,
            lastName: schema.userTable.lastName,
            lastname2: schema.userTable.lastname2,
            cellPhone: schema.userTable.cellPhone,
            externalId: schema.userTable.externalId,
            aggrementDate: schema.userTable.agreementAt,
        })
            .from(schema.userTable)
            .where((0, drizzle_orm_1.eq)(schema.userTable.email, email))
            .then((rows) => {
            if (rows.length === 0) {
                this.LOGGER.log(`No user found with email: ${email}`);
                return null;
            }
            this.LOGGER.log(`Found user with email: ${email}`);
            return new domain_1.User(rows[0].id, rows[0].name, rows[0].email, rows[0].lastName, rows[0].lastname2, rows[0].cellPhone, rows[0].externalId ? rows[0].externalId : undefined, rows[0].aggrementDate ? rows[0].aggrementDate : undefined);
        });
    }
    async findById(id, tx) {
        this.LOGGER.log(`Finding user by id: ${id}`);
        return await (tx || this.db.conn)
            .select({
            id: schema.userTable.id,
            name: schema.userTable.name,
            email: schema.userTable.email,
            lastName: schema.userTable.lastName,
            lastname2: schema.userTable.lastname2,
            cellPhone: schema.userTable.cellPhone,
            externalId: schema.userTable.externalId,
            aggrementDate: schema.userTable.agreementAt,
        })
            .from(schema.userTable)
            .where((0, drizzle_orm_1.eq)(schema.userTable.id, id))
            .then((rows) => {
            if (rows.length === 0) {
                this.LOGGER.log(`No user found with id: ${id}`);
                return null;
            }
            this.LOGGER.log(`Found user with id: ${id}`);
            return new domain_1.User(rows[0].id, rows[0].name, rows[0].email, rows[0].lastName, rows[0].lastname2, rows[0].cellPhone, rows[0].externalId ? rows[0].externalId : undefined, rows[0].aggrementDate ? rows[0].aggrementDate : undefined);
        });
    }
    async findByExternalId(externalId) {
        this.LOGGER.log(`Finding user by externalId: ${externalId}`);
        return await this.db.conn
            .select({
            id: schema.userTable.id,
            name: schema.userTable.name,
            email: schema.userTable.email,
            lastName: schema.userTable.lastName,
            lastname2: schema.userTable.lastname2,
            cellPhone: schema.userTable.cellPhone,
            externalId: schema.userTable.externalId,
            aggrementDate: schema.userTable.agreementAt,
        })
            .from(schema.userTable)
            .where((0, drizzle_orm_1.eq)(schema.userTable.externalId, externalId))
            .then((rows) => {
            if (rows.length === 0) {
                this.LOGGER.log(`No user found with externalId: ${externalId}`);
                return null;
            }
            this.LOGGER.log(`Found user with externalId: ${externalId}`);
            return new domain_1.User(rows[0].id, rows[0].name, rows[0].email, rows[0].lastName, rows[0].lastname2, rows[0].cellPhone, rows[0].externalId ? rows[0].externalId : undefined, rows[0].aggrementDate ? rows[0].aggrementDate : undefined);
        });
    }
    async save(user) {
        this.LOGGER.log(`Saving user with email: ${user.email}`);
        const validatedUser = schema.userTableInsertSchema.parse(user);
        const insertedUserId = await this.db.conn
            .insert(schema.userTable)
            .values(validatedUser)
            .$returningId()
            .then((rows) => {
            this.LOGGER.log(`Inserted user with id: ${rows[0].id}`);
            return rows[0].id;
        });
        return await this.findById(insertedUserId).then((user) => {
            if (user) {
                this.LOGGER.log(`User saved successfully with id: ${user.id}`);
                return user;
            }
            this.LOGGER.error('User not found after save');
            throw new Error('User not found');
        });
    }
    async update(id, user) {
        this.LOGGER.log(`Updating user with id: ${id}`);
        const validatedUser = schema.userTableUpdateSchema.parse(user);
        await this.db.conn
            .update(schema.userTable)
            .set({ ...validatedUser, updatedAt: util_1.TenderUtil.getCurrentSystemDate() })
            .where((0, drizzle_orm_1.eq)(schema.userTable.id, id));
        return await this.findById(id).then((user) => {
            if (user) {
                this.LOGGER.log(`User updated successfully with id: ${user.id}`);
                return user;
            }
            else {
                this.LOGGER.error('User not found after update');
                throw new Error('User not found');
            }
        });
    }
    async findUserProfiles(userId) {
        this.LOGGER.log(`Finding profiles for user id: ${userId}`);
        return await this.db.conn
            .select({
            id: schema.roleTable.id,
            name: schema.roleTable.name,
            shortName: schema.roleTable.shortName,
        })
            .from(schema.roleTable)
            .innerJoin(schema.userRoleTable, (0, drizzle_orm_1.eq)(schema.roleTable.id, schema.userRoleTable.roleId))
            .where((0, drizzle_orm_1.eq)(schema.userRoleTable.userId, userId))
            .then((rows) => {
            this.LOGGER.log(`Found ${rows.length} profiles for user id: ${userId}`);
            return rows.map((row) => new domain_1.Role(row.id, row.name, row.shortName));
        });
    }
    async updateAggrement(user) {
        this.LOGGER.log(`Updating user agreement with id: ${user.id}`);
        await this.db.conn
            .update(schema.userTable)
            .set({ updatedAt: util_1.TenderUtil.getCurrentSystemDate(), agreementAt: util_1.TenderUtil.getCurrentSystemDate(),
            cellPhone: user.cellPhone
        })
            .where((0, drizzle_orm_1.eq)(schema.userTable.id, user.id));
        return 'ok';
    }
    async unsubscribe(userId) {
        this.LOGGER.log(`Unsubscribing user with id: ${userId}`);
        await this.db.conn
            .update(schema.userTable)
            .set({ deletedAt: util_1.TenderUtil.getCurrentSystemDate(), active: false })
            .where((0, drizzle_orm_1.eq)(schema.userTable.id, userId));
        return await this.findById(userId).then((user) => {
            if (user) {
                this.LOGGER.log(`User unsubscribed successfully with id: ${user.id}`);
                return user;
            }
            else {
                this.LOGGER.error('User not found after unsubscribe');
                throw new Error('User not found');
            }
        });
    }
    async erraseAccount(userId) {
        this.LOGGER.log(`erraseAccount id: ${userId}`);
        await this.db.conn.transaction(async (tx) => {
            await tx
                .delete(schema.userDeviceTable)
                .where((0, drizzle_orm_1.eq)(schema.userDeviceTable.userId, userId));
            this.LOGGER.log(`Deleted userDeviceTable records for userId: ${userId}`);
            await tx
                .delete(schema.userCompanyTenderTable)
                .where((0, drizzle_orm_1.eq)(schema.userCompanyTenderTable.userId, userId));
            this.LOGGER.log(`Deleted userCompanyTenderTable records for userId: ${userId}`);
            await tx
                .delete(schema.userCompanyTable)
                .where((0, drizzle_orm_1.eq)(schema.userCompanyTable.userId, userId));
            this.LOGGER.log(`Deleted userCompanyTable records for userId: ${userId}`);
            await tx
                .delete(schema.notificationRecordTable)
                .where((0, drizzle_orm_1.eq)(schema.notificationRecordTable.userId, userId));
            this.LOGGER.log(`Deleted notificationRecordTable records for userId: ${userId}`);
            await tx
                .delete(schema.userHistoryTenderTable)
                .where((0, drizzle_orm_1.eq)(schema.userHistoryTenderTable.userId, userId));
            this.LOGGER.log(`Deleted userHistoryTenderTable records for userId: ${userId}`);
            await tx
                .delete(schema.userRoleTable)
                .where((0, drizzle_orm_1.eq)(schema.userRoleTable.userId, userId));
            this.LOGGER.log(`Deleted userRoleTable records for userId: ${userId}`);
            await tx
                .delete(schema.userRequestTable)
                .where((0, drizzle_orm_1.eq)(schema.userRequestTable.userId, userId));
            this.LOGGER.log(`Deleted userRequestTable records for userId: ${userId}`);
            await tx
                .delete(schema.userTable)
                .where((0, drizzle_orm_1.eq)(schema.userTable.id, userId));
            this.LOGGER.log(`Deleted userTable record for userId: ${userId}`);
        });
        return true;
    }
};
exports.UserRepositoryImpl = UserRepositoryImpl;
exports.UserRepositoryImpl = UserRepositoryImpl = UserRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_provider_1.DBConfigService])
], UserRepositoryImpl);
//# sourceMappingURL=user-repository-impl.js.map