"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var UserRequestRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserRequestRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const domain_1 = require("../../../domain");
const app_exception_logger_1 = require("../../definition/logger/app.exception.logger");
const drizzle_provider_1 = require("../../drizzle/drizzle.provider");
const schema = require("../../drizzle/migrations/schema");
const drizzle_orm_1 = require("drizzle-orm");
const util_1 = require("util");
const util_2 = require("../../../../licitaapp/domain/util");
let UserRequestRepositoryImpl = UserRequestRepositoryImpl_1 = class UserRequestRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new app_exception_logger_1.PrimeLogger(UserRequestRepositoryImpl_1.name);
    }
    async countActiveUserRequests() {
        this.LOGGER.log('Counting active user requests');
        return await this.db.conn
            .select({ count: (0, drizzle_orm_1.count)() })
            .from(schema.userRequestTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(schema.userRequestTable.active, true), (0, drizzle_orm_1.eq)(schema.userRequestTable.stateRequestTypeId, 5)))
            .then((rows) => {
            return rows[0].count;
        });
    }
    async erraseUserRequests(tenderIds) {
        this.LOGGER.log(`Erasing user requests for tender IDs: ${tenderIds.join(', ')}`);
        await this.db.conn
            .delete(schema.userRequestTable)
            .where((0, drizzle_orm_1.inArray)(schema.userRequestTable.tenderId, tenderIds.map((t) => t.tenderId)))
            .execute();
    }
    async save(dataInsert, userId, tx) {
        this.LOGGER.log(`save repository: ${(0, util_1.inspect)(dataInsert)}`);
        const validatedUserRequest = schema.userRequestTableInsertSchema.parse({
            userId: userId,
            tenderId: dataInsert.tenderId,
            companyId: +dataInsert.companyId,
            stateRequestTypeId: 5,
            title: dataInsert.title,
            description: dataInsert.description,
        });
        const insertedUserRequestId = await (tx || this.db.conn)
            .insert(schema.userRequestTable)
            .values(validatedUserRequest)
            .$returningId()
            .then((rows) => {
            return rows[0].id;
        });
        return await this.findById(insertedUserRequestId, tx).then((dataObject) => {
            if (dataObject) {
                return dataObject;
            }
            else {
                throw new Error('UserRequest not found');
            }
        });
    }
    async existUserRequest(userId, tenderId, companyId) {
        this.LOGGER.log(`existUserRequest repository: ${userId}`);
        return await this.db.conn
            .select({
            id: schema.userRequestTable.id,
        })
            .from(schema.userRequestTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(schema.userRequestTable.userId, userId), (0, drizzle_orm_1.eq)(schema.userRequestTable.tenderId, tenderId), (0, drizzle_orm_1.eq)(schema.userRequestTable.companyId, companyId)))
            .then((rows) => {
            if (rows.length === 0) {
                return 0;
            }
            return rows[0].id;
        });
    }
    async findById(id, tx) {
        this.LOGGER.log(`findById repository: ${id}`);
        return await (tx || this.db.conn)
            .select({
            id: schema.userRequestTable.id,
            userId: schema.userRequestTable.userId,
            tenderId: schema.userRequestTable.tenderId,
            companyId: schema.userRequestTable.companyId,
            stateRequestTypeId: schema.userRequestTable.stateRequestTypeId,
            createdAt: schema.userRequestTable.createdAt,
            updatedAt: schema.userRequestTable.updatedAt,
            title: schema.userRequestTable.title,
            description: schema.userRequestTable.description,
        })
            .from(schema.userRequestTable)
            .where((0, drizzle_orm_1.eq)(schema.userRequestTable.id, id))
            .then((rows) => {
            if (rows.length === 0) {
                return null;
            }
            let newValue = new domain_1.UserRequest(rows[0].id, rows[0].companyId, rows[0].stateRequestTypeId, rows[0].title, rows[0].tenderId, rows[0].description, rows[0].userId);
            newValue.createdAt = rows[0].createdAt;
            newValue.updatedAt = rows[0].updatedAt;
            return newValue;
        });
    }
    async update(userRequestId, objectUpdateData, tx) {
        this.LOGGER.log(`update repository: ${userRequestId}`);
        const validatedUserRequest = schema.userRequestTableUpdateSchema.parse({
            stateRequestTypeId: objectUpdateData.stateRequestTypeId,
            updatedAt: util_2.TenderUtil.getCurrentSystemDate(),
        });
        await (tx || this.db.conn)
            .update(schema.userRequestTable)
            .set(validatedUserRequest)
            .where((0, drizzle_orm_1.eq)(schema.userRequestTable.id, userRequestId))
            .execute();
        return await this.findById(userRequestId, tx).then((dataObject) => {
            if (dataObject) {
                return dataObject;
            }
            else {
                throw new Error('UserRequest not found');
            }
        });
    }
    async getPagination(page, pageSize, shortStateUserRequest, filter) {
        const offset = (page - 1) * pageSize;
        const selectFields = {
            field1: schema.userRequestTable.id,
            field2: schema.companyTable.socialReason,
            field3: schema.companyTable.dni,
            field4: schema.tenderTable.code,
            field5: schema.userTable.name,
            field6: schema.userTable.lastName,
            field7: schema.userRequestTable.createdAt,
            field8: schema.userRequestTable.updatedAt,
            field9: schema.typeMasterTable.name,
            field10: schema.userTable.email,
            field11: schema.userTable.cellPhone,
            field12: schema.userRequestTable.description,
            field13: schema.userRequestTable.title,
        };
        const query = this.db.conn
            .select(selectFields)
            .from(schema.userRequestTable)
            .leftJoin(schema.typeMasterTable, (0, drizzle_orm_1.eq)(schema.typeMasterTable.id, schema.userRequestTable.stateRequestTypeId))
            .leftJoin(schema.tenderTable, (0, drizzle_orm_1.eq)(schema.tenderTable.id, schema.userRequestTable.tenderId))
            .leftJoin(schema.companyTable, (0, drizzle_orm_1.eq)(schema.companyTable.id, schema.userRequestTable.companyId))
            .leftJoin(schema.userTable, (0, drizzle_orm_1.eq)(schema.userTable.id, schema.userRequestTable.userId))
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(schema.typeMasterTable.shortName, shortStateUserRequest)))
            .orderBy((0, drizzle_orm_1.desc)(schema.userRequestTable.updatedAt))
            .limit(Number(pageSize))
            .offset(offset);
        const rows = await query;
        if (rows.length === 0) {
            return [];
        }
        return rows.map((row) => {
            const out = new domain_1.RequestTenderTO(row.field1, row.field2 ? row.field2 : '', row.field3 ? row.field3 : '', row.field4 ? row.field4 : '', this.evalFullName(row.field5, row.field6), row.field9 ? row.field9 : '', row.field11 ? row.field11 : '', row.field10 ? row.field10 : '', row.field7 ? row.field7 : null, row.field8 ? row.field8 : null);
            out.description = row.field12 + ' ' + row.field13;
            return out;
        });
    }
    evalFullName(name, lastName) {
        if (lastName) {
            return `${name} ${lastName}`;
        }
        return name ? name : '';
    }
    async logicalRemove(userRequestId, tx) {
        this.LOGGER.log(`logicalRemove repository: ${userRequestId}`);
        await (tx || this.db.conn)
            .update(schema.userRequestTable)
            .set({ active: false, deletedAt: util_2.TenderUtil.getCurrentSystemDate() })
            .where((0, drizzle_orm_1.eq)(schema.userRequestTable.id, userRequestId))
            .execute();
    }
    async updateState(userRequestId, stateRequestTypeId, active, tx) {
        this.LOGGER.log(`update repository: ${userRequestId}`);
        const validatedUserRequest = schema.userRequestTableUpdateSchema.parse({
            stateRequestTypeId: stateRequestTypeId,
            updatedAt: util_2.TenderUtil.getCurrentSystemDate(),
        });
        if (!active) {
            (validatedUserRequest.active = active),
                (validatedUserRequest.deletedAt = util_2.TenderUtil.getCurrentSystemDate());
        }
        await (tx || this.db.conn)
            .update(schema.userRequestTable)
            .set(validatedUserRequest)
            .where((0, drizzle_orm_1.eq)(schema.userRequestTable.id, userRequestId))
            .execute();
        return await this.findById(userRequestId, tx).then((dataObject) => {
            if (dataObject) {
                return dataObject;
            }
            else {
                throw new Error('UserRequest not found');
            }
        });
    }
};
exports.UserRequestRepositoryImpl = UserRequestRepositoryImpl;
exports.UserRequestRepositoryImpl = UserRequestRepositoryImpl = UserRequestRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_provider_1.DBConfigService])
], UserRequestRepositoryImpl);
//# sourceMappingURL=user-request-repository-impl.js.map