"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var EmailServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const app_exception_logger_1 = require("../../definition/logger/app.exception.logger");
const config_1 = require("@nestjs/config");
const mailer_1 = require("@nestjs-modules/mailer");
const fs = require("fs/promises");
const util_1 = require("util");
let EmailServiceImpl = EmailServiceImpl_1 = class EmailServiceImpl {
    constructor(mailerService, configService) {
        this.mailerService = mailerService;
        this.configService = configService;
        this.LOGGER = new app_exception_logger_1.PrimeLogger(EmailServiceImpl_1.name);
    }
    async sendEmail({ to, subject }) {
        try {
            this.LOGGER.log('Sending email to ' + to);
            const pathBase = this.configService.get('BASE_TEMPLATE_PATH');
            this.LOGGER.log('Path base templates: ' + pathBase);
            let template = await fs.readFile(`${pathBase}/BaseTemplate.html`, 'utf8');
            await this.mailerService.sendMail({
                to: to,
                cc: 'yurifull.evolution@gmail.com',
                subject: subject,
                html: template,
            });
        }
        catch (error) {
            this.LOGGER.error(`Failed to send email to ${to}: ${(0, util_1.inspect)(error)}`);
        }
    }
    async sendNewsEmail(to, subject, dayOfweekLabel, amountWordsTender = 0, amountGeoTenders = 0) {
        try {
            this.LOGGER.log('Sending email to ' + to);
            const pathBase = this.configService.get('BASE_TEMPLATE_PATH');
            this.LOGGER.log('Path base templates: ' +
                pathBase +
                '-' +
                dayOfweekLabel +
                '-' +
                amountWordsTender +
                '-' +
                amountGeoTenders);
            let template = await fs.readFile(`${pathBase}/NewsTemplate.html`, 'utf8');
            await this.mailerService.sendMail({
                to: to,
                cc: 'yurifull.evolution@gmail.com',
                subject: subject,
                html: template
                    .replace('DAY_WEEK', dayOfweekLabel)
                    .replace('XXX', amountWordsTender.toString())
                    .replace('YYY', amountGeoTenders.toString()),
            });
        }
        catch (error) {
            this.LOGGER.error(`Failed to send news email to ${to}: ${(0, util_1.inspect)(error)}`);
        }
    }
    async sendAdminEmail(to, subject, message) {
        try {
            this.LOGGER.log('Sending email to ' + to);
            const pathBase = this.configService.get('BASE_TEMPLATE_PATH');
            this.LOGGER.log('Path base templates: ' + pathBase + '-' + message);
            let template = await fs.readFile(`${pathBase}/AdminTemplate.html`, 'utf8');
            await this.mailerService.sendMail({
                to: to,
                cc: 'yurifull.evolution@gmail.com',
                subject: subject,
                html: template.replace('MESSAGE', message),
            });
        }
        catch (error) {
            this.LOGGER.error(`Failed to send admin email to ${to}: ${(0, util_1.inspect)(error)}`);
        }
    }
    async sendUserRequest(email, fullname) {
        try {
            this.LOGGER.log('SendUserRequest email to ' + email);
            const pathBase = this.configService.get('BASE_TEMPLATE_PATH');
            this.LOGGER.log('Path base templates: ' + pathBase + '/UserRequest');
            let template = await fs.readFile(`${pathBase}/UserRequest.html`, 'utf8');
            template = template.replace('#FULLNAME#', fullname);
            let response = await this.mailerService.sendMail({
                to: email,
                cc: 'yurifull.evolution@gmail.com',
                subject: 'Requerimiento de usuario',
                html: template,
            });
            this.LOGGER.log('Email sent: ', (0, util_1.inspect)(response));
        }
        catch (error) {
            this.LOGGER.error(`Failed to send user request email to ${email}: ${(0, util_1.inspect)(error)}`);
        }
    }
};
exports.EmailServiceImpl = EmailServiceImpl;
exports.EmailServiceImpl = EmailServiceImpl = EmailServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [mailer_1.MailerService,
        config_1.ConfigService])
], EmailServiceImpl);
//# sourceMappingURL=email-service-impl.js.map