import { EmailService, FirebaseService, UserDeviceService, UserService } from 'src/framework/application';
import * as admin from 'firebase-admin';
import { NotificationRecordService } from 'src/framework/application/service/notification-record-service/notification-record-service.interface';
type NotificationData = {
    [key: string]: string;
};
export declare class FirebaseImplService implements FirebaseService {
    private readonly notificationRecordService;
    private readonly userDeviceService;
    private readonly emailService;
    private readonly LOGGER;
    private readonly messaging;
    private readonly auth;
    constructor(notificationRecordService: NotificationRecordService, userDeviceService: UserDeviceService, emailService: EmailService);
    sendAllNotificationsRecords(): Promise<void>;
    verifyIdToken(idToken: string): Promise<admin.auth.DecodedIdToken>;
    stringToNumberHash(str: string): number;
    sendPushNotification(tokens: string[], title: string, body: string, data?: NotificationData): Promise<import("firebase-admin/lib/messaging/messaging-api").BatchResponse | undefined>;
    deleteUserFromFirebase(uid: string): Promise<void>;
    groupNotifications(userId: number): Promise<void>;
    notifyToAdminUsers(countActiveRequests: number): Promise<void>;
    sendDailyEmailSumary(applicationLogId: number): Promise<string>;
    sendNewsEmail(email: string, dayOfweekLabel: string, amountWordsTender?: number, amountGeoTenders?: number): Promise<void>;
    sendEmailSumaryToAdmin(applicationLogId: number, userService: UserService): Promise<string>;
}
export {};
