"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var FwkCacheServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FwkCacheServiceImpl = exports.CacheManagerEnum = void 0;
const common_1 = require("@nestjs/common");
const definition_1 = require("../../definition");
const cache_manager_1 = require("@nestjs/cache-manager");
var CacheManagerEnum;
(function (CacheManagerEnum) {
    CacheManagerEnum["FIND_ALL_MATCHING_WORD"] = "FIND_ALL_MATCHING_WORD";
    CacheManagerEnum["FIND_ONE_MATCHING_WORD"] = "FIND_ONE_MATCHING_WORD_KEY";
    CacheManagerEnum["FIND_ALL_AGILE_DASHBOARD"] = "FIND_ALL_AGILE_DASHBOARD_KEY";
    CacheManagerEnum["SUBDIVISIONS_BY_COMPANY_ID"] = "SUBDIVISIONS_BY_COMPANY_ID_KEY";
    CacheManagerEnum["FIND_COMPANY_BY_ID"] = "FIND_COMPANY_BY_ID_KEY";
    CacheManagerEnum["USER_ROLES"] = "USER_ROLES_KEY";
    CacheManagerEnum["IDS_ACTIVE_COMPANIES"] = "IDS_ACTIVE_COMPANIES_KEY";
    CacheManagerEnum["COUNT_ACTIVE_USERS"] = "COUNT_ACTIVE_USERS_KEY";
    CacheManagerEnum["COUNT_ACTIVE_TENDERS"] = "COUNT_ACTIVE_TENDERS_KEY";
})(CacheManagerEnum || (exports.CacheManagerEnum = CacheManagerEnum = {}));
let FwkCacheServiceImpl = FwkCacheServiceImpl_1 = class FwkCacheServiceImpl {
    constructor(cacheManager) {
        this.cacheManager = cacheManager;
        this.LOGGER = new definition_1.PrimeLogger(FwkCacheServiceImpl_1.name);
    }
    static createKey(baseKey, params) {
        return `${baseKey}:${params.join(';')}`;
    }
    async getOrSet(key, fetchFn) {
        this.LOGGER.log(`Cache getOrSet key: ${key}`);
        const cached = await this.cacheManager.get(key);
        if (cached) {
            this.LOGGER.log(`Cache hit for key: ${key}`);
            return cached;
        }
        const result = await fetchFn();
        if (result) {
            this.LOGGER.log(`Cache set for key: ${key}`);
            await this.cacheManager.set(key, result);
        }
        return result;
    }
    async del(key) {
        this.cacheManager.stores.forEach(store => {
            store.clear();
        });
    }
};
exports.FwkCacheServiceImpl = FwkCacheServiceImpl;
exports.FwkCacheServiceImpl = FwkCacheServiceImpl = FwkCacheServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)(cache_manager_1.CACHE_MANAGER)),
    __metadata("design:paramtypes", [cache_manager_1.Cache])
], FwkCacheServiceImpl);
//# sourceMappingURL=fwk-cache-service-impl.js.map