import { GeoRepository } from 'src/framework/application/repository/geo-repository/geo-repository.interface';
import { GeoService } from 'src/framework/application/service/geo-service/geo-service.interface';
import { AdministrativeDivision } from 'src/framework/domain';
import { Subdivision } from 'src/framework/domain/entities/subdivision.entity';
export declare class GeoServiceImpl implements GeoService {
    private readonly repository;
    private readonly LOGGER;
    constructor(repository: GeoRepository);
    searchSubdivisionsByName(namesToSearch: string[]): Promise<{
        subdivision: Subdivision;
        administrativeDivision: AdministrativeDivision;
    } | undefined>;
    findCountries(): Promise<import("src/framework/domain").Country[]>;
    findCountryById(id: number): Promise<import("src/framework/domain").Country | null>;
    findSubdivisionsByCountryCode(countryCode: string): Promise<Subdivision[]>;
    findAdmdivisionsBySubdivisionCode(subdivisionCode: number): Promise<AdministrativeDivision[]>;
    findAdmdivisionsByCountry(prefix: string): Promise<AdministrativeDivision[]>;
}
