"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var GeoServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeoServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const definition_1 = require("../../definition");
let GeoServiceImpl = GeoServiceImpl_1 = class GeoServiceImpl {
    constructor(repository) {
        this.repository = repository;
        this.LOGGER = new definition_1.PrimeLogger(GeoServiceImpl_1.name);
    }
    async searchSubdivisionsByName(namesToSearch) {
        this.LOGGER.log(`searchSubdivisionsByName`);
        const normalizeText = (text) => text
            .toLowerCase()
            .normalize('NFD')
            .replace(/[\u0300-\u036f]/g, '')
            .replace(/[^a-z0-9 ]/g, '')
            .replace('de', '')
            .replace(' y ', '');
        const allSubdivisions = await this.repository.getAllSubdivisions();
        const getAllAdministrativeDivisions = await this.repository.getAllAdministrativeDivisions();
        const normalizedNames = namesToSearch.map(normalizeText);
        for (const subdivision of allSubdivisions) {
            const normalizedSubdivisionName = normalizeText(subdivision.name);
            const matchWithSubdivision = normalizedNames.some((name) => normalizedSubdivisionName.includes(name) ||
                name.includes(normalizedSubdivisionName));
            if (matchWithSubdivision) {
                const administrativeDivision = getAllAdministrativeDivisions.find((admDiv) => admDiv.id === subdivision.id);
                if (administrativeDivision) {
                    return { subdivision, administrativeDivision };
                }
            }
        }
        return undefined;
    }
    async findCountries() {
        this.LOGGER.log('Finding all countries');
        return await this.repository.findCountries();
    }
    async findCountryById(id) {
        this.LOGGER.log(`Finding country by id: ${id}`);
        return await this.repository.findCountryById(id);
    }
    async findSubdivisionsByCountryCode(countryCode) {
        this.LOGGER.log(`Finding subdivisions by country code: ${countryCode}`);
        return await this.repository.findSubdivisionsByCountryCode(countryCode);
    }
    async findAdmdivisionsBySubdivisionCode(subdivisionCode) {
        this.LOGGER.log(`Finding administrative divisions by subdivision code: ${subdivisionCode}`);
        return await this.repository.findAdmdivisionsBySubdivisionCode(subdivisionCode);
    }
    async findAdmdivisionsByCountry(prefix) {
        this.LOGGER.log(`Finding administrative divisions by country prefix: ${prefix}`);
        return await this.repository.findAdmdivisionsByCountry(prefix);
    }
};
exports.GeoServiceImpl = GeoServiceImpl;
exports.GeoServiceImpl = GeoServiceImpl = GeoServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('GeoRepository')),
    __metadata("design:paramtypes", [Object])
], GeoServiceImpl);
//# sourceMappingURL=geo-service-impl.js.map