"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var NotificationRecordServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationRecordServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const definition_1 = require("../../definition");
let NotificationRecordServiceImpl = NotificationRecordServiceImpl_1 = class NotificationRecordServiceImpl {
    constructor(notificationRecordRepository) {
        this.notificationRecordRepository = notificationRecordRepository;
        this.LOGGER = new definition_1.PrimeLogger(NotificationRecordServiceImpl_1.name);
    }
    erraseNotificationRecordsByTender(tenderIds, tx) {
        this.LOGGER.log(`Erasing notification records for tenders with IDs: ${tenderIds.join(', ')}`);
        return this.notificationRecordRepository.erraseNotificationRecordsByTender(tenderIds, tx);
    }
    getNotificationRecordsPaginated(userId, page, pageSize) {
        this.LOGGER.log(`Fetching notification records for user ${userId}, page ${page}, pageSize ${pageSize}`);
        return this.notificationRecordRepository.getNotificationRecordsPaginated(userId, page, pageSize);
    }
    getUserNotificationRecordsActive() {
        this.LOGGER.log('Fetching active user notification records');
        return this.notificationRecordRepository.getUserNotificationRecordsActive();
    }
    getAdminNotification() {
        this.LOGGER.log('Fetching admin notification records');
        return this.notificationRecordRepository.getAdminNotification();
    }
    saveAll(notificationRecords, tx) {
        this.LOGGER.log(`Saving ${notificationRecords.length} notification records`);
        return this.notificationRecordRepository.saveAll(notificationRecords, tx);
    }
    updateNotification(notificationRecordId, notificationRecord, tx) {
        this.LOGGER.log(`Updating notification record with ID ${notificationRecordId}`);
        return this.notificationRecordRepository.updateNotification(notificationRecordId, notificationRecord, tx);
    }
    getActiveNotificationRecords(userId, isAdmin) {
        this.LOGGER.log(`Fetching active notification records for user ${userId}, isAdmin: ${isAdmin}`);
        return this.notificationRecordRepository.getActiveNotificationRecords(userId, isAdmin);
    }
    logicalRemoveBYListId(notificationRecordIds, tx) {
        this.LOGGER.log(`Logically removing notification records with IDs: ${notificationRecordIds.join(', ')}`);
        return this.notificationRecordRepository.logicalRemoveBYListId(notificationRecordIds, tx);
    }
    markNotificationEmailAsSent(notificationRecordId, tx) {
        this.LOGGER.log(`Marking notification records as email sent for IDs: ${notificationRecordId.join(', ')}`);
        return this.notificationRecordRepository.markNotificationEmailAsSent(notificationRecordId, tx);
    }
};
exports.NotificationRecordServiceImpl = NotificationRecordServiceImpl;
exports.NotificationRecordServiceImpl = NotificationRecordServiceImpl = NotificationRecordServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('NotificationRecordRepository')),
    __metadata("design:paramtypes", [Object])
], NotificationRecordServiceImpl);
//# sourceMappingURL=notification-record-service-impl.js.map