"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var UserRequestServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserRequestServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const framework_1 = require("../../..");
let UserRequestServiceImpl = UserRequestServiceImpl_1 = class UserRequestServiceImpl {
    constructor(userRequestRepository, typeMasterService, userService, companyService, emailService, notificationRecordService, userRoleService, firebaseService) {
        this.userRequestRepository = userRequestRepository;
        this.typeMasterService = typeMasterService;
        this.userService = userService;
        this.companyService = companyService;
        this.emailService = emailService;
        this.notificationRecordService = notificationRecordService;
        this.userRoleService = userRoleService;
        this.firebaseService = firebaseService;
        this.LOGGER = new framework_1.PrimeLogger(UserRequestServiceImpl_1.name);
    }
    countActiveUserRequests() {
        this.LOGGER.log('Counting active user requests');
        return this.userRequestRepository.countActiveUserRequests();
    }
    erraseUserRequests(tenderIds) {
        this.LOGGER.log(`Erasing user requests for tender IDs: ${tenderIds.join(', ')}`);
        return this.userRequestRepository.erraseUserRequests(tenderIds);
    }
    async createProgramUserRequest(userId, dataUserRequest) {
        this.LOGGER.log(`Creating program user request for user: ${userId}`);
        const [company, user] = await Promise.all([
            this.companyService.findById(dataUserRequest.companyId),
            this.userService.getUserById(userId),
        ]);
        const notificationsArray = [
            {
                userId: userId,
                title: `Asistencia Programa de Integridad`,
                defaultMessage: `Pronto serás contactado por algún analista.`,
                active: true,
                isAdmin: false,
            },
        ];
        await this.userRequestRepository.save({
            companyId: dataUserRequest.companyId,
            title: dataUserRequest.title,
            description: dataUserRequest.description,
            stateRequestTypeId: 5,
            tenderId: null,
        }, userId);
        this.LOGGER.log(`Sending email to user: ${user.id}`);
        this.emailService.sendUserRequest(user.email, user.name);
        const adminIds = await this.userRoleService.getAdminUserIds();
        adminIds.forEach((adminId) => {
            notificationsArray.push({
                userId: adminId,
                title: `Programa de Integridad`,
                defaultMessage: `El cliente ${user?.name || ''} ${user?.lastName || ''} razón social ${company?.socialReason || ''} ha solicitado asistencia al Programa de Integridad.`,
                active: true,
                isAdmin: true,
            });
        });
        notificationsArray.length > 0 &&
            (await this.notificationRecordService.saveAll(notificationsArray));
        return 'true';
    }
    async createUserRequest(userId, dataUserRequest) {
        this.LOGGER.log(`Creating user request for user: ${userId}`);
        const userRequestId = await this.userRequestRepository.existUserRequest(userId, dataUserRequest.tenderId, dataUserRequest.companyId);
        let companyName = '';
        let fullName = '';
        if (dataUserRequest.companyId) {
            const company = await this.companyService.findById(dataUserRequest.companyId);
            companyName = company?.socialReason || '';
            const user = await this.userService.getUserById(userId);
            if (user) {
                fullName =
                    user &&
                        `${user.name} ${user.lastName != null ? user.lastName : ''} ${user.lastname2 != null ? user.lastname2 : ''}`.trim();
            }
        }
        if (userRequestId > 0) {
            await this.notificationRecordService.saveAll([
                {
                    userId: userId,
                    title: `Solicitud ${companyName}`,
                    defaultMessage: `El cliente ${fullName} ha vuelvo a solicitar apoyo de una licitación.`,
                    active: true,
                    tenderId: dataUserRequest.tenderId,
                    isAdmin: true,
                },
            ]);
            this.firebaseService.groupNotifications(userId);
            this.LOGGER.log(`Updating existing user request with id: ${userRequestId}`);
            return this.userRequestRepository.update(userRequestId, dataUserRequest);
        }
        this.LOGGER.log(`Creating new user request`);
        await this.notificationRecordService.saveAll([
            {
                userId: userId,
                title: `Solicitud ${companyName}`,
                defaultMessage: `El cliente ${fullName} ha levantado una solicitud de seguimiento.`,
                active: true,
                tenderId: dataUserRequest.tenderId,
                isAdmin: true,
            },
        ]);
        this.firebaseService.groupNotifications(userId);
        return this.userRequestRepository.save(dataUserRequest, userId);
    }
    async getPagination(page, pageSize, filter, shortStateUserRequest) {
        return this.userRequestRepository.getPagination(page, pageSize, shortStateUserRequest, filter);
    }
    async deleteLogicalRemove(userRequestId) {
        this.LOGGER.log(`Deleting user request: ${userRequestId}`);
        await this.userRequestRepository.logicalRemove(userRequestId);
    }
    async updateUserStateOrLogicalRemove(userRequestId, stateRequestType) {
        this.LOGGER.log(`Updating user request: ${userRequestId}`);
        const typeUserStatus = await this.typeMasterService.findByShortName(stateRequestType);
        if (!typeUserStatus) {
            this.LOGGER.error(`State type not found: ${stateRequestType}`);
            throw new Error(`State type not found: ${stateRequestType}`);
        }
        const active = stateRequestType == 'state.request.type.deleted' ? true : false;
        return this.userRequestRepository.updateState(userRequestId, typeUserStatus?.id, active);
    }
};
exports.UserRequestServiceImpl = UserRequestServiceImpl;
exports.UserRequestServiceImpl = UserRequestServiceImpl = UserRequestServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('UserRequestRepository')),
    __param(1, (0, common_1.Inject)('TypeMasterService')),
    __param(2, (0, common_1.Inject)('UserService')),
    __param(3, (0, common_1.Inject)('CompanyService')),
    __param(4, (0, common_1.Inject)('EmailService')),
    __param(5, (0, common_1.Inject)('NotificationRecordService')),
    __param(6, (0, common_1.Inject)('UserRoleService')),
    __param(7, (0, common_1.Inject)('FirebaseService')),
    __metadata("design:paramtypes", [Object, Object, Object, Object, Object, Object, Object, Object])
], UserRequestServiceImpl);
//# sourceMappingURL=user-request-service-impl.js.map