"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var UserRoleImplService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserRoleImplService = void 0;
const common_1 = require("@nestjs/common");
const definition_1 = require("../../definition");
const fwk_cache_service_impl_1 = require("../fwk-cache-service-impl/fwk-cache-service-impl");
let UserRoleImplService = UserRoleImplService_1 = class UserRoleImplService {
    constructor(userRoleRepository, roleService, fwkCacheService) {
        this.userRoleRepository = userRoleRepository;
        this.roleService = roleService;
        this.fwkCacheService = fwkCacheService;
        this.LOGGER = new definition_1.PrimeLogger(UserRoleImplService_1.name);
    }
    async getUserRoles(userId) {
        this.LOGGER.log(`Fetching roles for userId: ${userId}`);
        return await this.fwkCacheService.getOrSet(fwk_cache_service_impl_1.FwkCacheServiceImpl.createKey(fwk_cache_service_impl_1.CacheManagerEnum.USER_ROLES, [userId]), async () => {
            return this.userRoleRepository.getUserRoles(userId);
        });
    }
    async getAdminUserIds() {
        this.LOGGER.log('Fetching admin user IDs');
        return await this.userRoleRepository.getAdminUserIds();
    }
    async getAllPaginated(page, pageSize, email, profile) {
        this.LOGGER.log(`Fetching paginated user roles for page: ${page}, pageSize: ${pageSize}, profile: ${profile} email: ${email}`);
        const profileObj = await this.roleService.getRoleByKey(profile);
        if (!profileObj) {
            throw new Error(`Profile with short name ${profile} not found`);
        }
        return await this.userRoleRepository.getAllPaginated(page, pageSize, profileObj.id, email);
    }
    async updateProfiles(params, profileId) {
        this.LOGGER.log(`Updating user roles for userId: ${params.userId}, profileId: ${profileId}, isAdded: ${params.isAdded}`);
        await this.userRoleRepository.updateRoles(params, profileId);
        await this.fwkCacheService.del();
    }
    async getRolesByUserId(userId) {
        this.LOGGER.log(`Fetching roles for userId: ${userId}`);
        return await this.userRoleRepository.getRolesByUserId(userId);
    }
    async createUserRole(userId, roleId) {
        this.LOGGER.log(`Creating user role with userId: ${userId}, roleId: ${roleId}`);
        const result = await this.userRoleRepository.save(userId, roleId);
        await this.fwkCacheService.del();
        return result;
    }
};
exports.UserRoleImplService = UserRoleImplService;
exports.UserRoleImplService = UserRoleImplService = UserRoleImplService_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('UserRoleRepository')),
    __param(1, (0, common_1.Inject)('RoleService')),
    __param(2, (0, common_1.Inject)('FwkCacheService')),
    __metadata("design:paramtypes", [Object, Object, Object])
], UserRoleImplService);
//# sourceMappingURL=user-role-impl.service.js.map