import { InsertUser, User, UpdateUser, RecordTO, UserRoleTO } from 'src/framework/domain';
import { TxType } from 'src/framework/infrastructure/drizzle/drizzle.types';
import { EmailService, FirebaseService, RoleService, UserRepository, UserRoleService, UserService } from 'src/framework/application';
export declare class UserServiceImpl implements UserService {
    private readonly userRepository;
    private readonly firebaseService;
    private readonly userRoleService;
    private readonly roleService;
    private readonly emailService;
    private readonly LOGGER;
    constructor(userRepository: UserRepository, firebaseService: FirebaseService, userRoleService: UserRoleService, roleService: RoleService, emailService: EmailService);
    updateLastLogin(id: number): Promise<void>;
    updateProfiles(params: UserRoleTO): Promise<string>;
    findEmailsAdmin(): Promise<string[]>;
    createUser(user: InsertUser): Promise<User>;
    createOrUpdate(externalId: string, user: InsertUser): Promise<User>;
    getUserById(id: number, tx?: TxType): Promise<User | null | undefined>;
    getUserByExternalId(externalId: string): Promise<User | null | undefined>;
    getUserByEmail(email: string): Promise<User | null | undefined>;
    updateUser(id: number, user: UpdateUser): Promise<User>;
    getAllUsers(): Promise<User[]>;
    updateAggrement(user: User): Promise<string>;
    unsubscribe(user: User): Promise<void>;
    registerUserByProfile(recordTO: RecordTO): Promise<boolean>;
    errase(user: User): Promise<void>;
}
