import { HttpService } from '@nestjs/axios';
import { AgileTenderPageResponse, DetailAgileTenderTO, LicitacionesQueryParams, LicitacionesResponse, ListaEmpresasResponse, OrdenesDeCompraQueryParams, OrdenesDeCompraResponse } from './types';
export declare class MercadoPublicoRepository {
    private readonly httpService;
    private readonly LOGGER;
    constructor(httpService: HttpService);
    licitaciones(args: LicitacionesQueryParams): Promise<LicitacionesResponse | undefined>;
    licitacionesListadoDiarioGeneral(date: string): Promise<LicitacionesResponse | undefined>;
    licitacionesDetalleGeneral(codigo: string): Promise<LicitacionesResponse | undefined>;
    licitacionesAgiles(args: {
        initDate: string;
        endDate: string;
        page: number;
    }): Promise<AgileTenderPageResponse | undefined>;
    licitacionAgilDetail(codeAgileTender: string): Promise<DetailAgileTenderTO | undefined>;
    matchAgileKeyword(codeMercadoPublico: number): Promise<AgileTenderPageResponse>;
    ordenesDeCompra(args: OrdenesDeCompraQueryParams): Promise<OrdenesDeCompraResponse | undefined>;
    buscarProveedor(rut: string): Promise<ListaEmpresasResponse | undefined>;
    buscarComprador(): Promise<ListaEmpresasResponse | undefined>;
}
