"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var MercadoPublicoRepository_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MercadoPublicoRepository = void 0;
const axios_1 = require("@nestjs/axios");
const common_1 = require("@nestjs/common");
const rxjs_1 = require("rxjs");
const mp_util_1 = require("./mp.util");
const moment = require("moment-timezone");
const types_1 = require("./types");
const framework_1 = require("../../../framework");
const tender_fetcher_service_impl_1 = require("../../infrastructure/service/tender-fetcher-service-impl/tender-fetcher-service-impl");
let MercadoPublicoRepository = MercadoPublicoRepository_1 = class MercadoPublicoRepository {
    constructor(httpService) {
        this.httpService = httpService;
        this.LOGGER = new framework_1.PrimeLogger(MercadoPublicoRepository_1.name);
    }
    async licitaciones(args) {
        const urlGet = args.fecha ? `https://api.mercadopublico.cl/servicios/v1/publico/licitaciones.json?fecha=${args.fecha}&ticket=5DB9D72A-EA99-434D-B0F2-891BA3607F04`
            : `https://api.mercadopublico.cl/servicios/v1/publico/licitaciones.json?ticket=5DB9D72A-EA99-434D-B0F2-891BA3607F04&codigo=${args.codigo}`;
        this.LOGGER.warn(`USANDO URL: ${urlGet}`);
        const response = await (0, rxjs_1.firstValueFrom)(this.httpService
            .get(urlGet)
            .pipe((0, rxjs_1.map)((response) => types_1.LicitacionesResponse.fromJson((0, mp_util_1.convertDates)(response.data))))).catch((error) => {
            if (error.response) {
                this.LOGGER.error(`Error response: ${JSON.stringify(error.response.data)}`, 'MercadoPublicoRepository', error);
            }
            this.LOGGER.error(`Error retrieving licitaciones. ${error.message}. Params: ${JSON.stringify(args)}`, 'MercadoPublicoRepository', error);
            return undefined;
        });
        return response;
    }
    async licitacionesListadoDiarioGeneral(date) {
        const delay = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
        for (let attempt = 1; attempt <= 3; attempt++) {
            try {
                const response = await (0, rxjs_1.firstValueFrom)(this.httpService.get(`https://api.mercadopublico.cl/servicios/v1/publico/licitaciones.json?fecha=${date}&ticket=5DB9D72A-EA99-434D-B0F2-891BA3607F04`));
                return response.data;
            }
            catch (error) {
                if (attempt === Number(3)) {
                    this.LOGGER.debug(`Failed to fetch tender details for date: ${date}`);
                    this.LOGGER.error(`Error retrieving licitaciones for date ${date}. ${error.message}.`, 'MercadoPublicoRepository', error);
                }
                this.LOGGER.debug(`Attempt ${attempt} failed. Retrying in ${attempt * 1000}ms...`);
                await delay(attempt * 1000);
            }
        }
    }
    async licitacionesDetalleGeneral(codigo) {
        const delay = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
        for (let attempt = 1; attempt <= 3; attempt++) {
            try {
                const response = await (0, rxjs_1.firstValueFrom)(this.httpService.get(`https://api.mercadopublico.cl/servicios/v1/publico/licitaciones.json?ticket=5DB9D72A-EA99-434D-B0F2-891BA3607F04&codigo=${codigo}`));
                return response.data;
            }
            catch (error) {
                if (attempt === Number(3)) {
                    this.LOGGER.debug(`Failed to fetch tender details for codigo: ${codigo}`);
                    this.LOGGER.error(`Error retrieving licitaciones for date ${error.message}.`, 'MercadoPublicoRepository', error);
                }
                this.LOGGER.debug(`Attempt ${attempt} failed. Retrying in ${attempt * 1000}ms...`);
                await delay(attempt * 1000);
            }
        }
    }
    async licitacionesAgiles(args) {
        const { initDate, endDate, page } = args;
        try {
            const response = await (0, rxjs_1.firstValueFrom)(this.httpService
                .get(`https://api.buscador.mercadopublico.cl/compra-agil?date_from=${initDate}&date_to=${endDate}&order_by=recent&page_number=${page}&status=2`, {
                headers: {
                    'x-api-key': 'e93089e4-437c-4723-b343-4fa20045e3bc',
                },
            }));
            return response.data;
        }
        catch (error) {
            this.LOGGER.error(`Error retrieving licitaciones agiles. ${error.message}. Params: ${JSON.stringify(args)}`, 'MercadoPublicoRepository', error);
            this.LOGGER.error(`Error retrieving licitaciones for ${error.message}.`, 'MercadoPublicoRepository', error);
            return undefined;
        }
    }
    async licitacionAgilDetail(codeAgileTender) {
        try {
            const response = await (0, rxjs_1.firstValueFrom)(this.httpService
                .get(`https://api.buscador.mercadopublico.cl/compra-agil?action=ficha&code=${encodeURIComponent(codeAgileTender)}`, {
                headers: {
                    'x-api-key': 'e93089e4-437c-4723-b343-4fa20045e3bc',
                },
            }));
            const data = response.data;
            return data.payload;
        }
        catch (error) {
            this.LOGGER.error(`Error retrieving licitaciones agiles. ${error.message}. Params: ${codeAgileTender}`, 'MercadoPublicoRepository', error);
            throw error;
        }
    }
    async matchAgileKeyword(codeMercadoPublico) {
        try {
            const now = moment().tz(tender_fetcher_service_impl_1.TenderFetcherServiceImpl.TIMEZONE);
            const tomorrow = now.add(1, 'day').format('YYYY-MM-DD');
            const lastMonth = moment().tz(tender_fetcher_service_impl_1.TenderFetcherServiceImpl.TIMEZONE).subtract(30, 'days').format('YYYY-MM-DD');
            const response = await (0, rxjs_1.firstValueFrom)(this.httpService
                .get(`https://api.buscador.mercadopublico.cl/compra-agil?date_from=${lastMonth}&date_to=${tomorrow}&order_by=recent&category=${codeMercadoPublico}&status=2`, {
                headers: {
                    'x-api-key': 'e93089e4-437c-4723-b343-4fa20045e3bc',
                },
            }));
            return response.data;
        }
        catch (error) {
            this.LOGGER.error(`Error retrieving licitaciones agiles. ${error.message}. Params: ${JSON.stringify(codeMercadoPublico)}`, 'MercadoPublicoRepository', error);
            throw error;
        }
    }
    async ordenesDeCompra(args) {
        types_1.OrdenesDeCompraQueryParamsSchema.parse(args);
        const response = await (0, rxjs_1.firstValueFrom)(this.httpService
            .get('/ordenesdecompra.json', {
            params: args,
        })
            .pipe((0, rxjs_1.map)((response) => types_1.OrdenesDeCompraResponse.fromJson((0, mp_util_1.convertDates)(response.data))))).catch((error) => {
            this.LOGGER.error(`Error retrieving ordenes de compra. ${error.message}. Params: ${JSON.stringify(args)}`, 'MercadoPublicoRepository');
            throw error;
        });
        return response;
    }
    async buscarProveedor(rut) {
        const response = await (0, rxjs_1.firstValueFrom)(this.httpService
            .get('/empresas/BuscarProveedor', {
            params: {
                rutempresaproveedor: rut,
            },
        })
            .pipe((0, rxjs_1.map)((response) => response.data))).catch((error) => {
            this.LOGGER.error(`Error: ${JSON.stringify(error)}`, 'MercadoPublicoRepository');
            return undefined;
        });
        return response;
    }
    async buscarComprador() {
        const response = await (0, rxjs_1.firstValueFrom)(this.httpService
            .get('/empresas/BuscarComprador')
            .pipe((0, rxjs_1.map)((response) => response.data))).catch((error) => {
            this.LOGGER.error(`Error: ${JSON.stringify(error)}`, 'MercadoPublicoRepository');
            return undefined;
        });
        return response;
    }
};
exports.MercadoPublicoRepository = MercadoPublicoRepository;
exports.MercadoPublicoRepository = MercadoPublicoRepository = MercadoPublicoRepository_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [axios_1.HttpService])
], MercadoPublicoRepository);
//# sourceMappingURL=mp.repository.js.map