"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertDates = convertDates;
const moment = require("moment-timezone");
const CHILE_TIMEZONE = 'America/Santiago';
function convertDates(obj, defaultTimezone = CHILE_TIMEZONE) {
    if (Array.isArray(obj)) {
        return obj.map((item) => convertDates(item, defaultTimezone));
    }
    else if (obj !== null && typeof obj === 'object') {
        return Object.keys(obj).reduce((acc, key) => {
            const value = obj[key];
            if (typeof value === 'string' && key.startsWith('Fecha')) {
                if (value.endsWith('Z')) {
                    acc[key] = new Date(value);
                }
                else {
                    acc[key] = moment.tz(value, defaultTimezone).toDate();
                }
            }
            else {
                acc[key] = convertDates(value, defaultTimezone);
            }
            return acc;
        }, {});
    }
    return obj;
}
//# sourceMappingURL=mp.util.js.map