import { z } from 'zod';
interface Comprador {
    CodigoOrganismo: string;
    NombreOrganismo: string;
    RutUnidad: string;
    CodigoUnidad: string;
    NombreUnidad: string;
    DireccionUnidad: string;
    ComunaUnidad: string;
    RegionUnidad: string;
    RutUsuario: string;
    CodigoUsuario: string;
    NombreUsuario: string;
    CargoUsuario: string;
}
interface Fechas {
    FechaCreacion: string;
    FechaCierre: string | undefined;
    FechaInicio: string;
    FechaFinal: string;
    FechaPubRespuestas: string;
    FechaActoAperturaTecnica: string;
    FechaActoAperturaEconomica: string;
    FechaPublicacion: string;
    FechaAdjudicacion: string;
    FechaEstimadaAdjudicacion: string;
    FechaSoporteFisico: string | undefined;
    FechaTiempoEvaluacion: string | undefined;
    FechaEstimadaFirma: string;
    FechasUsuario: string | undefined;
    FechaVisitaTerreno: string | undefined;
    FechaEntregaAntecedentes: string | undefined;
}
declare enum AdjudicacionTipoEnum {
    AUTORIZACION = 1,
    RESOLUCION = 2,
    ACUERDO = 3,
    DECRETO = 4,
    OTROS = 5
}
interface Adjudicacion {
    Tipo: AdjudicacionTipoEnum | undefined;
    Fecha: string | undefined;
    Numero: string | undefined;
    NumeroOferentes: number;
    UrlActa: string;
}
interface Item {
    Correlativo: number;
    CodigoProducto: number;
    CodigoCategoria: string;
    Categoria: string;
    NombreProducto: string;
    Descripcion: string;
    UnidadMedida: string;
    Cantidad: number;
    Adjudicacion: string | undefined;
}
interface Items {
    Cantidad: number;
    Listado: Item[];
}
declare enum MonedaEnum {
    CLP = "CLP",
    CLF = "CLF",
    USD = "USD",
    UTM = "UTM",
    EUR = "EUR"
}
declare enum ModalidadPagoEnum {
    PAGO_30_DIAS = 1,
    PAGO_30_60_90_DIAS = 2,
    PAGO_AL_DIA = 3,
    PAGO_ANUAL = 4,
    PAGO_BIMENSUAL = 5,
    PAGO_CONTRA_ENTREGA_CONFORME = 6,
    PAGOS_MENSUALES = 7,
    PAGO_POR_ESTADO_DE_AVANCE = 8,
    PAGO_TRIMESTRAL = 9,
    PAGO_60_DIAS = 10
}
declare enum UnidadTiempoEnum {
    HORAS = 1,
    DIAS = 2,
    SEMANAS = 3,
    MESES = 4,
    ANOS = 5
}
declare enum TipoEnum {
    L1 = "L1",
    LE = "LE",
    LP = "LP",
    LQ = "LQ",
    LR = "LR",
    E2 = "E2",
    CO = "CO",
    B2 = "B2",
    H2 = "H2",
    I2 = "I2",
    LS = "LS"
}
interface Listado {
    CodigoExterno: string;
    Nombre: string;
    CodigoEstado: number;
    Descripcion: string;
    FechaCierre: string | undefined;
    Estado: string;
    Comprador: Comprador;
    DiasCierreLicitacion: string;
    Informada: boolean;
    CodigoTipo: number;
    Tipo: TipoEnum;
    TipoConvocatoria: number;
    Moneda: MonedaEnum;
    Etapas: number;
    EstadoEtapas: string;
    TomaRazon: number;
    EstadoPublicidadOfertas: number;
    JustificacionPublicidad: string;
    Contrato: number;
    Obras: number;
    CantidadReclamos: number;
    Fechas: Fechas;
    UnidadTiempoEvaluacion: UnidadTiempoEnum;
    DireccionVisita: string;
    DireccionEntrega: string;
    Estimacion: number;
    FuenteFinanciamiento: string;
    VisibilidadMonto: boolean;
    MontoEstimado: number | undefined;
    Tiempo: string | undefined;
    UnidadTiempo: UnidadTiempoEnum;
    Modalidad: ModalidadPagoEnum;
    TipoPago: string;
    NombreResponsablePago: string;
    EmailResponsablePago: string;
    NombreResponsableContrato: string;
    EmailResponsableContrato: string;
    FonoResponsableContrato: string;
    ProhibicionContratacion: string;
    SubContratacion: boolean;
    UnidadTiempoDuracionContrato: number;
    TiempoDuracionContrato: string;
    TipoDuracionContrato: string;
    JustificacionMontoEstimado: string | undefined;
    ObservacionContract: string | undefined;
    ExtensionPlazo: boolean;
    EsBaseTipo: boolean;
    UnidadTiempoContratoLicitacion: string;
    ValorTiempoRenovacion: string;
    PeriodoTiempoRenovacion: string;
    EsRenovable: boolean;
    Adjudicacion: Adjudicacion;
    Items: Items;
}
declare class LicitacionesResponse {
    Cantidad: number;
    FechaCreacion: string;
    Version: string;
    Listado: Listado[];
    static fromJson(data: LicitacionesResponse): LicitacionesResponse;
}
declare class AgileTenderTO {
    id: number;
    codigo: string;
    nombre: string;
    fecha_publicacion: string;
    fecha_cierre: string;
    organismo: string;
    unidad: string;
    id_estado: number;
    estado: string;
    monto_disponible: number;
    moneda: MonedaEnum;
    monto_disponible_CLP: number;
    fecha_cambio: string | null;
    valor_cambio_moneda: number | null;
    cantidad_proveedores_cotizando: number;
    estado_convocatoria: number;
    lastUpdatedAt?: Date | null;
    tenderAgileId?: number | null;
    closeDate?: Date | null;
}
declare class PageAgileTenderPayload {
    resultCount: number;
    pageCount: number;
    page: number;
    pageSize: number;
    resultados: AgileTenderTO[];
}
declare class AgileTenderPageResponse {
    success: string;
    trace: string;
    errores: string;
    payload: PageAgileTenderPayload;
    static fromJson(data: AgileTenderPageResponse): AgileTenderPageResponse;
}
declare class MatchWordTO {
    words: string[];
}
declare enum EstadoQueryEnum {
    PUBLICADA = "Publicada",
    CERRADA = "Cerrada",
    DESIERTA = "Desierta",
    ADJUDICADA = "Adjudicada",
    REVOCADA = "Revocada",
    SUSPENDIDA = "Suspendida",
    ACTIVAS = "activas"
}
declare class InformacionInstitucionTO {
    organismo_comprador: string;
    rut_organismo_comprador: string;
    division: string;
}
declare class ProductoSolicitadoTO {
    codigo_producto: number;
    nombre: string;
    descripcion: string;
    cantidad: number;
    unidad_medida: string;
}
declare class DetailAgileTenderTO {
    detalle_id: number;
    codigo: string;
    nombre: string;
    descripcion: string;
    fecha_publicacion: string;
    fecha_cierre: string;
    id_estado: number;
    estado: string;
    direccion_entrega?: string;
    plazo_entrega?: number;
    presupuesto_estimado?: number;
    moneda: MonedaEnum;
    motivo_cancelacion?: string | null;
    fecha_cancelacion?: string | null;
    multa_sancion?: number;
    cantidad_proveedores_invitados: number;
    productos_solicitados: ProductoSolicitadoTO[];
    informacion_institucion: InformacionInstitucionTO;
    id_orden_compra?: number | null;
    fecha_cierre_primer_llamado: string;
    fecha_cierre_segundo_llamado?: string | null;
    tipo_presupuesto: string;
    estado_convocatoria: number;
    motivo_seleccion?: string | null;
    criterio_seleccion?: string | null;
    total_demandas: number;
    total_ofertas_recibidas: number;
    motivo_desierta?: string | null;
    considera_requisitos_medioambientales: boolean;
    considera_requisitos_impacto_social_economico: boolean;
}
declare class AgileTenderDetailResponse {
    success: string;
    trace: string;
    errores: string;
    payload: DetailAgileTenderTO;
}
declare const LicitacionesQueryParamsSchema: z.ZodEffects<z.ZodObject<{
    codigo: z.ZodOptional<z.ZodString>;
    fecha: z.ZodOptional<z.ZodString>;
    estado: z.ZodOptional<z.ZodNativeEnum<typeof EstadoQueryEnum>>;
    CodigoOrganismo: z.ZodOptional<z.ZodString>;
    CodigoProveedor: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    codigo?: string | undefined;
    fecha?: string | undefined;
    estado?: EstadoQueryEnum | undefined;
    CodigoOrganismo?: string | undefined;
    CodigoProveedor?: string | undefined;
}, {
    codigo?: string | undefined;
    fecha?: string | undefined;
    estado?: EstadoQueryEnum | undefined;
    CodigoOrganismo?: string | undefined;
    CodigoProveedor?: string | undefined;
}>, {
    codigo?: string | undefined;
    fecha?: string | undefined;
    estado?: EstadoQueryEnum | undefined;
    CodigoOrganismo?: string | undefined;
    CodigoProveedor?: string | undefined;
}, {
    codigo?: string | undefined;
    fecha?: string | undefined;
    estado?: EstadoQueryEnum | undefined;
    CodigoOrganismo?: string | undefined;
    CodigoProveedor?: string | undefined;
}>;
type LicitacionesQueryParams = z.infer<typeof LicitacionesQueryParamsSchema>;
declare class AgileTenderFullInfoTO {
    general: AgileTenderTO;
    licitacionAgilDetail?: DetailAgileTenderTO | undefined;
}
export { Listado as Licitacion, AgileTenderTO, LicitacionesQueryParams, LicitacionesQueryParamsSchema, LicitacionesResponse, AgileTenderPageResponse, MatchWordTO, DetailAgileTenderTO, ProductoSolicitadoTO, EstadoQueryEnum, InformacionInstitucionTO, AgileTenderDetailResponse, AgileTenderFullInfoTO };
