"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AgileTenderFullInfoTO = exports.AgileTenderDetailResponse = exports.InformacionInstitucionTO = exports.EstadoQueryEnum = exports.ProductoSolicitadoTO = exports.DetailAgileTenderTO = exports.MatchWordTO = exports.AgileTenderPageResponse = exports.LicitacionesResponse = exports.LicitacionesQueryParamsSchema = exports.AgileTenderTO = void 0;
const swagger_1 = require("@nestjs/swagger");
const zod_1 = require("zod");
var AdjudicacionTipoEnum;
(function (AdjudicacionTipoEnum) {
    AdjudicacionTipoEnum[AdjudicacionTipoEnum["AUTORIZACION"] = 1] = "AUTORIZACION";
    AdjudicacionTipoEnum[AdjudicacionTipoEnum["RESOLUCION"] = 2] = "RESOLUCION";
    AdjudicacionTipoEnum[AdjudicacionTipoEnum["ACUERDO"] = 3] = "ACUERDO";
    AdjudicacionTipoEnum[AdjudicacionTipoEnum["DECRETO"] = 4] = "DECRETO";
    AdjudicacionTipoEnum[AdjudicacionTipoEnum["OTROS"] = 5] = "OTROS";
})(AdjudicacionTipoEnum || (AdjudicacionTipoEnum = {}));
var MonedaEnum;
(function (MonedaEnum) {
    MonedaEnum["CLP"] = "CLP";
    MonedaEnum["CLF"] = "CLF";
    MonedaEnum["USD"] = "USD";
    MonedaEnum["UTM"] = "UTM";
    MonedaEnum["EUR"] = "EUR";
})(MonedaEnum || (MonedaEnum = {}));
var ModalidadPagoEnum;
(function (ModalidadPagoEnum) {
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_30_DIAS"] = 1] = "PAGO_30_DIAS";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_30_60_90_DIAS"] = 2] = "PAGO_30_60_90_DIAS";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_AL_DIA"] = 3] = "PAGO_AL_DIA";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_ANUAL"] = 4] = "PAGO_ANUAL";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_BIMENSUAL"] = 5] = "PAGO_BIMENSUAL";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_CONTRA_ENTREGA_CONFORME"] = 6] = "PAGO_CONTRA_ENTREGA_CONFORME";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGOS_MENSUALES"] = 7] = "PAGOS_MENSUALES";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_POR_ESTADO_DE_AVANCE"] = 8] = "PAGO_POR_ESTADO_DE_AVANCE";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_TRIMESTRAL"] = 9] = "PAGO_TRIMESTRAL";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_60_DIAS"] = 10] = "PAGO_60_DIAS";
})(ModalidadPagoEnum || (ModalidadPagoEnum = {}));
var UnidadTiempoEnum;
(function (UnidadTiempoEnum) {
    UnidadTiempoEnum[UnidadTiempoEnum["HORAS"] = 1] = "HORAS";
    UnidadTiempoEnum[UnidadTiempoEnum["DIAS"] = 2] = "DIAS";
    UnidadTiempoEnum[UnidadTiempoEnum["SEMANAS"] = 3] = "SEMANAS";
    UnidadTiempoEnum[UnidadTiempoEnum["MESES"] = 4] = "MESES";
    UnidadTiempoEnum[UnidadTiempoEnum["ANOS"] = 5] = "ANOS";
})(UnidadTiempoEnum || (UnidadTiempoEnum = {}));
var TipoEnum;
(function (TipoEnum) {
    TipoEnum["L1"] = "L1";
    TipoEnum["LE"] = "LE";
    TipoEnum["LP"] = "LP";
    TipoEnum["LQ"] = "LQ";
    TipoEnum["LR"] = "LR";
    TipoEnum["E2"] = "E2";
    TipoEnum["CO"] = "CO";
    TipoEnum["B2"] = "B2";
    TipoEnum["H2"] = "H2";
    TipoEnum["I2"] = "I2";
    TipoEnum["LS"] = "LS";
})(TipoEnum || (TipoEnum = {}));
class LicitacionesResponse {
    static fromJson(data) {
        data.Listado = data.Listado.map((item) => {
            item.Informada = item.Informada === 1;
            item.VisibilidadMonto =
                item.VisibilidadMonto === 1;
            item.SubContratacion = item.SubContratacion === 1;
            item.ExtensionPlazo = item.ExtensionPlazo === 1;
            item.EsBaseTipo = item.EsBaseTipo === 1;
            item.EsRenovable = item.EsRenovable === 1;
            return item;
        });
        return data;
    }
}
exports.LicitacionesResponse = LicitacionesResponse;
class AgileTenderTO {
}
exports.AgileTenderTO = AgileTenderTO;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Agile Tender id',
        example: 1,
    }),
    __metadata("design:type", Number)
], AgileTenderTO.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Agile Tender code',
        example: '1111-111-A111',
    }),
    __metadata("design:type", String)
], AgileTenderTO.prototype, "codigo", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Name',
        example: '1111-111-A111',
    }),
    __metadata("design:type", String)
], AgileTenderTO.prototype, "nombre", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Date formatted publication',
        example: '1111-111-A111',
    }),
    __metadata("design:type", String)
], AgileTenderTO.prototype, "fecha_publicacion", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Date formatted close',
        example: '1111-111-A111',
    }),
    __metadata("design:type", String)
], AgileTenderTO.prototype, "fecha_cierre", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Organism',
        example: '1111-111-A111',
    }),
    __metadata("design:type", String)
], AgileTenderTO.prototype, "organismo", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Unit',
        example: '1111-111-A111',
    }),
    __metadata("design:type", String)
], AgileTenderTO.prototype, "unidad", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Agile state',
        example: 1,
    }),
    __metadata("design:type", Number)
], AgileTenderTO.prototype, "id_estado", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Estado',
        example: '1111-111-A111',
    }),
    __metadata("design:type", String)
], AgileTenderTO.prototype, "estado", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Amount',
        example: 1,
    }),
    __metadata("design:type", Number)
], AgileTenderTO.prototype, "monto_disponible", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'MonedaEnum',
        enum: MonedaEnum,
        enumName: 'MonedaEnum',
    }),
    __metadata("design:type", String)
], AgileTenderTO.prototype, "moneda", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Amount in clp',
        example: 1,
    }),
    __metadata("design:type", Number)
], AgileTenderTO.prototype, "monto_disponible_CLP", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Date of last change',
        example: '1111-111-A111',
        required: false,
    }),
    __metadata("design:type", Object)
], AgileTenderTO.prototype, "fecha_cambio", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Value of currency exchange',
        example: 1,
        required: false,
    }),
    __metadata("design:type", Object)
], AgileTenderTO.prototype, "valor_cambio_moneda", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Number of suppliers quoting',
        example: 1,
    }),
    __metadata("design:type", Number)
], AgileTenderTO.prototype, "cantidad_proveedores_cotizando", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'State of the call',
        example: 1,
    }),
    __metadata("design:type", Number)
], AgileTenderTO.prototype, "estado_convocatoria", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Last update date',
        example: '1991-01-01T00:00:00.000Z',
        type: Date,
        required: false,
    }),
    __metadata("design:type", Object)
], AgileTenderTO.prototype, "lastUpdatedAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Agile bussiness id',
        example: 1,
        required: false,
        type: Number,
    }),
    __metadata("design:type", Object)
], AgileTenderTO.prototype, "tenderAgileId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Close date',
        example: '1991-01-01T00:00:00.000Z',
        type: Date,
        required: false,
    }),
    __metadata("design:type", Object)
], AgileTenderTO.prototype, "closeDate", void 0);
class PageAgileTenderPayload {
}
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Total results',
        example: 1,
    }),
    __metadata("design:type", Number)
], PageAgileTenderPayload.prototype, "resultCount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Total pages',
        example: 1,
    }),
    __metadata("design:type", Number)
], PageAgileTenderPayload.prototype, "pageCount", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Current page',
        example: 1,
    }),
    __metadata("design:type", Number)
], PageAgileTenderPayload.prototype, "page", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Page size',
        example: 10,
    }),
    __metadata("design:type", Number)
], PageAgileTenderPayload.prototype, "pageSize", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Agile Tender Results',
        type: [AgileTenderTO],
        isArray: true,
    }),
    __metadata("design:type", Array)
], PageAgileTenderPayload.prototype, "resultados", void 0);
class AgileTenderPageResponse {
    static fromJson(data) {
        return data;
    }
}
exports.AgileTenderPageResponse = AgileTenderPageResponse;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Success',
        example: 'true',
    }),
    __metadata("design:type", String)
], AgileTenderPageResponse.prototype, "success", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Success',
        example: 'true',
    }),
    __metadata("design:type", String)
], AgileTenderPageResponse.prototype, "trace", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Trace',
        example: '',
    }),
    __metadata("design:type", String)
], AgileTenderPageResponse.prototype, "errores", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Agile Tender Page Payload',
        type: PageAgileTenderPayload,
    }),
    __metadata("design:type", PageAgileTenderPayload)
], AgileTenderPageResponse.prototype, "payload", void 0);
class MatchWordTO {
}
exports.MatchWordTO = MatchWordTO;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'word to match',
        required: true,
        type: () => [String],
    }),
    __metadata("design:type", Array)
], MatchWordTO.prototype, "words", void 0);
var EstadoQueryEnum;
(function (EstadoQueryEnum) {
    EstadoQueryEnum["PUBLICADA"] = "Publicada";
    EstadoQueryEnum["CERRADA"] = "Cerrada";
    EstadoQueryEnum["DESIERTA"] = "Desierta";
    EstadoQueryEnum["ADJUDICADA"] = "Adjudicada";
    EstadoQueryEnum["REVOCADA"] = "Revocada";
    EstadoQueryEnum["SUSPENDIDA"] = "Suspendida";
    EstadoQueryEnum["ACTIVAS"] = "activas";
})(EstadoQueryEnum || (exports.EstadoQueryEnum = EstadoQueryEnum = {}));
class InformacionInstitucionTO {
}
exports.InformacionInstitucionTO = InformacionInstitucionTO;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Buyer organization',
        example: 'I MUNICIPALIDAD DE SAN PEDRO DE ATACAMA',
    }),
    __metadata("design:type", String)
], InformacionInstitucionTO.prototype, "organismo_comprador", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Buyer organization RUT',
        example: '70.816.700-2',
    }),
    __metadata("design:type", String)
], InformacionInstitucionTO.prototype, "rut_organismo_comprador", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Division',
        example: 'Depto. de Salud',
    }),
    __metadata("design:type", String)
], InformacionInstitucionTO.prototype, "division", void 0);
class ProductoSolicitadoTO {
}
exports.ProductoSolicitadoTO = ProductoSolicitadoTO;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Product code',
        example: 43233501,
    }),
    __metadata("design:type", Number)
], ProductoSolicitadoTO.prototype, "codigo_producto", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Product name',
        example: 'Software de correo electrónico',
    }),
    __metadata("design:type", String)
], ProductoSolicitadoTO.prototype, "nombre", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Product description',
        example: 'Renovación incluye 22 cuentas de correo...',
    }),
    __metadata("design:type", String)
], ProductoSolicitadoTO.prototype, "descripcion", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Quantity',
        example: 22,
    }),
    __metadata("design:type", Number)
], ProductoSolicitadoTO.prototype, "cantidad", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Unit of measure',
        example: 'EA',
    }),
    __metadata("design:type", String)
], ProductoSolicitadoTO.prototype, "unidad_medida", void 0);
class DetailAgileTenderTO {
}
exports.DetailAgileTenderTO = DetailAgileTenderTO;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Detail ID',
        example: 4942775,
    }),
    __metadata("design:type", Number)
], DetailAgileTenderTO.prototype, "detalle_id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender code',
        example: '4999-129-COT25',
    }),
    __metadata("design:type", String)
], DetailAgileTenderTO.prototype, "codigo", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender name',
        example: 'Renovación de servidor VPS y cuentas de correo WorkSpace Google',
    }),
    __metadata("design:type", String)
], DetailAgileTenderTO.prototype, "nombre", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender description',
        example: 'El Departamento de Salud, requiere para la planificación...',
    }),
    __metadata("design:type", String)
], DetailAgileTenderTO.prototype, "descripcion", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Publication date formatted',
        example: '2025-11-17 12:05',
    }),
    __metadata("design:type", String)
], DetailAgileTenderTO.prototype, "fecha_publicacion", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Close date formatted',
        example: '2025-11-19 13:00',
    }),
    __metadata("design:type", String)
], DetailAgileTenderTO.prototype, "fecha_cierre", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'State ID',
        example: 2,
    }),
    __metadata("design:type", Number)
], DetailAgileTenderTO.prototype, "id_estado", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'State description',
        example: 'Publicada',
    }),
    __metadata("design:type", String)
], DetailAgileTenderTO.prototype, "estado", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Delivery address',
        example: 'Calle Toconao #413',
        required: false,
    }),
    __metadata("design:type", String)
], DetailAgileTenderTO.prototype, "direccion_entrega", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Delivery term in days',
        example: 4,
        required: false,
    }),
    __metadata("design:type", Number)
], DetailAgileTenderTO.prototype, "plazo_entrega", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Estimated budget',
        example: 1,
        required: false,
    }),
    __metadata("design:type", Number)
], DetailAgileTenderTO.prototype, "presupuesto_estimado", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Currency',
        enum: MonedaEnum,
        enumName: 'MonedaEnum',
    }),
    __metadata("design:type", String)
], DetailAgileTenderTO.prototype, "moneda", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Cancellation reason',
        example: null,
        required: false,
    }),
    __metadata("design:type", Object)
], DetailAgileTenderTO.prototype, "motivo_cancelacion", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Cancellation date',
        example: null,
        required: false,
    }),
    __metadata("design:type", Object)
], DetailAgileTenderTO.prototype, "fecha_cancelacion", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Fine or sanction',
        example: 1,
        required: false,
    }),
    __metadata("design:type", Number)
], DetailAgileTenderTO.prototype, "multa_sancion", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Number of invited suppliers',
        example: 0,
    }),
    __metadata("design:type", Number)
], DetailAgileTenderTO.prototype, "cantidad_proveedores_invitados", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Requested products',
        type: [ProductoSolicitadoTO],
    }),
    __metadata("design:type", Array)
], DetailAgileTenderTO.prototype, "productos_solicitados", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Institution information',
        type: InformacionInstitucionTO,
    }),
    __metadata("design:type", InformacionInstitucionTO)
], DetailAgileTenderTO.prototype, "informacion_institucion", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Purchase order ID',
        example: null,
        required: false,
    }),
    __metadata("design:type", Object)
], DetailAgileTenderTO.prototype, "id_orden_compra", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'First call close date',
        example: '2025-11-19 13:00',
    }),
    __metadata("design:type", String)
], DetailAgileTenderTO.prototype, "fecha_cierre_primer_llamado", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Second call close date',
        example: null,
        required: false,
    }),
    __metadata("design:type", Object)
], DetailAgileTenderTO.prototype, "fecha_cierre_segundo_llamado", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Budget type',
        example: 'Estimado',
    }),
    __metadata("design:type", String)
], DetailAgileTenderTO.prototype, "tipo_presupuesto", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Call state',
        example: 1,
    }),
    __metadata("design:type", Number)
], DetailAgileTenderTO.prototype, "estado_convocatoria", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Selection reason',
        example: null,
        required: false,
    }),
    __metadata("design:type", Object)
], DetailAgileTenderTO.prototype, "motivo_seleccion", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Selection criteria',
        example: null,
        required: false,
    }),
    __metadata("design:type", Object)
], DetailAgileTenderTO.prototype, "criterio_seleccion", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Total demands',
        example: 0,
    }),
    __metadata("design:type", Number)
], DetailAgileTenderTO.prototype, "total_demandas", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Total received offers',
        example: 1,
    }),
    __metadata("design:type", Number)
], DetailAgileTenderTO.prototype, "total_ofertas_recibidas", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Desert reason',
        example: null,
        required: false,
    }),
    __metadata("design:type", Object)
], DetailAgileTenderTO.prototype, "motivo_desierta", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Considers environmental requirements',
        example: false,
    }),
    __metadata("design:type", Boolean)
], DetailAgileTenderTO.prototype, "considera_requisitos_medioambientales", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Considers social economic impact requirements',
        example: false,
    }),
    __metadata("design:type", Boolean)
], DetailAgileTenderTO.prototype, "considera_requisitos_impacto_social_economico", void 0);
class AgileTenderDetailResponse {
}
exports.AgileTenderDetailResponse = AgileTenderDetailResponse;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Success',
        example: 'true',
    }),
    __metadata("design:type", String)
], AgileTenderDetailResponse.prototype, "success", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Trace',
        example: '',
    }),
    __metadata("design:type", String)
], AgileTenderDetailResponse.prototype, "trace", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Errors',
        example: '',
    }),
    __metadata("design:type", String)
], AgileTenderDetailResponse.prototype, "errores", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Agile Tender Detail Payload',
        type: DetailAgileTenderTO,
    }),
    __metadata("design:type", DetailAgileTenderTO)
], AgileTenderDetailResponse.prototype, "payload", void 0);
const LicitacionesQueryParamsSchema = zod_1.z
    .object({
    codigo: zod_1.z.string().optional(),
    fecha: zod_1.z.string().optional(),
    estado: zod_1.z.nativeEnum(EstadoQueryEnum).optional(),
    CodigoOrganismo: zod_1.z.string().optional(),
    CodigoProveedor: zod_1.z.string().optional(),
})
    .refine((data) => {
    const keys = [
        'codigo',
        'fecha',
        'estado',
        'CodigoOrganismo',
        'CodigoProveedor',
    ];
    const providedKeys = keys.filter((key) => data[key] !== undefined);
    return providedKeys.length === 1;
}, {
    message: 'Only one filter can be used at a time.',
    path: [],
});
exports.LicitacionesQueryParamsSchema = LicitacionesQueryParamsSchema;
class AgileTenderFullInfoTO {
}
exports.AgileTenderFullInfoTO = AgileTenderFullInfoTO;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'General information of agile tender',
        type: AgileTenderTO,
        required: true,
    }),
    __metadata("design:type", AgileTenderTO)
], AgileTenderFullInfoTO.prototype, "general", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Detail of agile tender',
        type: DetailAgileTenderTO,
        required: false,
    }),
    __metadata("design:type", Object)
], AgileTenderFullInfoTO.prototype, "licitacionAgilDetail", void 0);
//# sourceMappingURL=mp.licitaciones.types.js.map