import { TxType } from "src/framework";
import { InsertKeyword, Keyword, Metadata } from "src/licitaapp/domain";
export interface KeywordRepository {
    logicalRemove(id: number, tx?: TxType): Promise<void>;
    findById(id: number, tx?: TxType): Promise<Keyword | null | undefined>;
    findByCodeCategoriaMercadoPublico(codeCategoriaMercadoPublico: number[], tx?: TxType | undefined): Promise<Keyword[]>;
    getAllWithouthMetadata(tx?: TxType): Promise<Keyword[]>;
    updateMetadata(keywordId: number, metadata: Metadata): Promise<void>;
    save(keyword: InsertKeyword, tx?: TxType): Promise<Keyword>;
    saveAll(keywords: InsertKeyword[], tx?: TxType): Promise<Keyword[]>;
    findAdminValues(): Promise<string[]>;
    findKeywordsByNameList(names: string[]): Promise<number[]>;
}
