import { GeneralDataInfoTO, InsertTender, Licitacion, PaginationNormalTenderTO, RequestTender, Tender, TenderHistoryTO, TenderTO } from "src/licitaapp/domain";
import { AgileTender, InsertAgileTender, MinimalToEditAgileTender, UpdateMinimalToEditAgileTender } from "src/licitaapp/domain/entities/agile-tender.entity";
import { AgileTenderFullInfoTO } from "../../mercado-publico";
import { PaginationAgileTenderTO } from "src/licitaapp/domain/dto/pagination-agile-tender.to";
export interface TenderRepository {
    createGeneralDataQuery(): Promise<GeneralDataInfoTO>;
    countActiveTenders(): Promise<number>;
    getLogicalRemoveTenderIds(): Promise<TenderTO[]>;
    logicalRemove(tenderId: number): Promise<void>;
    findByCode(code: string): Promise<Tender | undefined>;
    findByDates(initDate: Date, endDate: Date): Promise<RequestTender[]>;
    findWithoutCloseDate(): Promise<Tender[]>;
    findWithoutSubdivision(): Promise<Tender[]>;
    findByCloseDate(endDate: Date): Promise<Tender[]>;
    findByDatesUpset(initDate: Date, endDate: Date): Promise<Tender[]>;
    getNormalTenderAdminPaginated(page: number, pageSize: number, order: string, filter: string): Promise<PaginationNormalTenderTO[]>;
    findById(id: number): Promise<Tender | undefined>;
    findBySubdivisionId(subdivisionId: number, withLimit?: boolean): Promise<Tender[]>;
    findInfohistoryTender(tenderId: number[]): Promise<TenderHistoryTO[]>;
    upsert(tender: InsertTender): Promise<number>;
    updateField(tender: {
        id: number;
        active: boolean;
        detail?: Licitacion;
        subdivisionId?: number | null;
    }): Promise<void>;
    updateCloseDate(tender: {
        id: number;
        closeDate: Date | null;
    }): Promise<void>;
    updateLogicalRemove(tender: {
        id: number;
        state: boolean;
    }): Promise<void>;
    updateSubdivision(tender: {
        id: number;
        subdivisionId?: number | null;
    }): Promise<void>;
    erraseByListId(tenderIds: number[]): Promise<void>;
    findByColumnLike(column: string, value: string): Promise<Tender[]>;
    findByCloseDateAgileTender(endDate: Date): Promise<number[]>;
    upsertAgileTender(tender: InsertAgileTender): Promise<number>;
    erraseAgileOldTenders(agileTenderIds: number[]): Promise<void>;
    getAgileTenderWithouthMetadata(): Promise<AgileTender[]>;
    getTotalAmountAgileTenders(userId: number, companyId: number, subdivisionIds: number[]): Promise<{
        favoriteMoney: number;
        totalMoney: number;
        totalSubdivision: number;
        agileKeywordAmount: number;
    }>;
    getAgileTenderPaginated(page: number, pageSize: number, typeSearch: string, subdivisionIds: number[], companyId: number, userId: number): Promise<AgileTenderFullInfoTO[]>;
    getAgileTenderAdminPaginated(page: number, pageSize: number, order: string, filter: string): Promise<PaginationAgileTenderTO[]>;
    getAgileTenderById(agileTenderId: number): Promise<AgileTender | null | undefined>;
    getAgileTenderMinimalToEditById(agileTendrId: number): Promise<MinimalToEditAgileTender | undefined>;
    updateMinimalAgileTender(dataAgiletender: UpdateMinimalToEditAgileTender): Promise<void>;
}
