import { Subdivision } from "src/framework/domain/entities/subdivision.entity";
import { Company, CompanyFullTO, CompanyRegisterTO } from "src/licitaapp/domain";
import { PaginationKeywordTO } from "src/licitaapp/domain/dto/company.user.to";
import { UserPaginationTO } from "src/licitaapp/domain/dto/user.pagination.to";
export interface CompanyService {
    createCompany(userId: number, insertCompany: CompanyRegisterTO): Promise<CompanyFullTO | null>;
    findByDNI(dni: string): Promise<Company | null>;
    findById(id: number): Promise<Company | null>;
    findByIdWithFetch(id: number): Promise<CompanyFullTO | null>;
    getCompanyIdsToRecalculateTender(): Promise<number[]>;
    getSubdivisionsByCompanyId(companyId: number): Promise<Subdivision[]>;
    getCompanyIdsActive(): Promise<number[]>;
    paginationByCompanyAdmin(page: number, pageSize: number): Promise<UserPaginationTO>;
    updateCheckTenders(companyId: number, checkTender: boolean): Promise<boolean>;
    updateCompany(companyId: number, userId: number, updateCompany: CompanyRegisterTO): Promise<CompanyFullTO | null>;
    getAllCompanyWithoutKeywords(): Promise<number[]>;
    paginationByCompanyKeyword(page: number, pageSize: number, socialReason?: string): Promise<PaginationKeywordTO[]>;
}
