import { InsertMatchingWord, MatchingWord, UpdateMatchingWord } from 'src/licitaapp/domain';
export interface MatchingWordService {
    findAll(): Promise<MatchingWord[]>;
    getPagination(page: number, pageSize: number, subdivisionId?: string, wordSearch?: string): Promise<MatchingWord[]>;
    findById(id: number): Promise<MatchingWord | null | undefined>;
    save(matchingWord: InsertMatchingWord): Promise<boolean>;
    update(matchingWord: UpdateMatchingWord): Promise<boolean>;
    delete(matchingWordId: number): Promise<boolean>;
    findSubdivisionIdByMatchingWords(word: string): Promise<number | null | undefined>;
}
