import { FirebaseService, User, UserRequestService } from "src/framework";
import { DashboardTO, GeneralDataInfoTO, HistoryTender, HistoryTenderDetail, InsertTender, PaginationNormalTenderTO, Tender } from "src/licitaapp/domain";
import { AgileTender, InsertAgileTender, MinimalToEditAgileTender, UpdateMinimalToEditAgileTender } from "src/licitaapp/domain/entities/agile-tender.entity";
import { ApplicationTypeEnum } from "src/licitaapp/domain/enum/enum.definition";
import { AgileTenderFullInfoTO } from "../../mercado-publico";
import { PaginationAgileTenderTO } from "src/licitaapp/domain/dto/pagination-agile-tender.to";
export interface TenderService {
    addTenderByCodeToCompany(code: string, companyId: number): Promise<string>;
    checkCloseDate(applicationLogId: number): Promise<string>;
    checkNewTendersUserCompany(applicationLogId: number): Promise<string>;
    checkTenderFavoritesToClose(applicationLogId: number): Promise<string>;
    checkTenderWithCloseDate(applicationLogId: number): Promise<string>;
    checkTenderSubdivision(applicationLogId: number): Promise<string>;
    createDashboardCompany(companyId: number, userId: number[]): Promise<void>;
    generateInfoDashboard(user: User, companyId: number): Promise<DashboardTO>;
    getListTenderHistory(userId: number): Promise<HistoryTender[]>;
    getPaginatedHistoryTenders(userId: number, page: number, pageSize: number): Promise<HistoryTenderDetail[]>;
    getPaginatedTenders(userId: number, companyId: number, page: number, pageSize: number, searchType: string, filterLabel: string): Promise<Tender[]>;
    getTenderByCode(code: string, userId?: number): Promise<Tender | undefined>;
    getNormalTenderAdminPaginated(page: number, pageSize: number, order: string, filter: string): Promise<PaginationNormalTenderTO[]>;
    logicalRemoveCompanyTenderUser(userId: number, companyId: number, tenderId: number): Promise<void>;
    recalculteTender(applicationLogId: number): Promise<string>;
    reviewTendersInfo(action: ApplicationTypeEnum): Promise<void>;
    reviewTenderStatus(applicationLogId: number): Promise<string>;
    searchTenderToUserCompanyWithSubdivision(companyId: number, userId: number): Promise<void>;
    getFirebaseService(): FirebaseService;
    tenderTaskEvery5Minutes(): Promise<void>;
    tenderTaskPerMinutes(): Promise<void>;
    tenderTaskBy2Hour(): Promise<void>;
    tenderTaskPerDay(): Promise<void>;
    tenderTaskByHour(): Promise<void>;
    updateFavoriteUserCompanytender(userId: number, companyId: number, tenderId: number, isFavorite: boolean): Promise<void>;
    upsert(tender: InsertTender): Promise<number>;
    erraseOldTenders(): Promise<string>;
    logAndExecute(type: ApplicationTypeEnum, applicationLogId: number, action: (applicationLogId: number) => Promise<string>): Promise<void>;
    createApplicationLogID(type: ApplicationTypeEnum): Promise<number>;
    upsertAgileTender(tender: InsertAgileTender): Promise<number>;
    findByCloseDateAgileTender(endDate: Date): Promise<number[]>;
    erraseAgileOldTenders(agileTenderIds: number[]): Promise<void>;
    getAgileTenderPaginated(page: number, pageSize: number, typeSearch: string, companyId: number, userId: number): Promise<AgileTenderFullInfoTO[]>;
    getAgileTenderWithouthMetadata(): Promise<AgileTender[]>;
    getAgileTenderById(agileTendrId: number): Promise<AgileTender | null | undefined>;
    getAgileTenderMinimalToEditById(agileTendrId: number): Promise<MinimalToEditAgileTender | undefined>;
    getAgileTenderAdminPaginated(page: number, pageSize: number, order: string, filter: string): Promise<PaginationAgileTenderTO[]>;
    updateMinimalAgileTender(dataAgiletender: UpdateMinimalToEditAgileTender): Promise<void>;
    createGeneralDataQuery(): Promise<GeneralDataInfoTO>;
    countActiveTenders(): Promise<number>;
    getUserRequestService(): UserRequestService;
}
