"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaginationKeywordTO = exports.CompanyUserTO = void 0;
const swagger_1 = require("@nestjs/swagger");
const user_minimal_to_1 = require("./user.minimal.to");
const entities_1 = require("../entities");
class CompanyUserBaseTO {
}
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Company id',
        example: 16,
        type: Number,
        required: true,
    }),
    __metadata("design:type", Number)
], CompanyUserBaseTO.prototype, "companyId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Company name',
        example: 'Example Company',
        type: String,
        required: true,
    }),
    __metadata("design:type", String)
], CompanyUserBaseTO.prototype, "socialReason", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({
        description: 'Company fields user',
        type: String,
        required: true,
    }),
    __metadata("design:type", String)
], CompanyUserBaseTO.prototype, "dni", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Company active status',
        example: true,
        type: Boolean,
        required: true,
    }),
    __metadata("design:type", Boolean)
], CompanyUserBaseTO.prototype, "active", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Company fields user',
        example: 15,
        type: Number,
        required: true,
    }),
    __metadata("design:type", Number)
], CompanyUserBaseTO.prototype, "amountTenders", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Users',
        type: () => [user_minimal_to_1.UserMinimalTO],
        required: true,
    }),
    __metadata("design:type", Array)
], CompanyUserBaseTO.prototype, "listUsers", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Company fields user',
        example: 15,
        type: Number,
        required: true,
    }),
    __metadata("design:type", Number)
], CompanyUserBaseTO.prototype, "amountAgileTenders", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Keywords',
        type: () => [entities_1.Keyword],
        required: true,
    }),
    __metadata("design:type", Array)
], CompanyUserBaseTO.prototype, "listKeywords", void 0);
class PaginationKeywordTO extends (0, swagger_1.OmitType)(CompanyUserBaseTO, ['listUsers']) {
}
exports.PaginationKeywordTO = PaginationKeywordTO;
class CompanyUserTO extends (0, swagger_1.OmitType)(CompanyUserBaseTO, ['listKeywords', 'amountAgileTenders']) {
}
exports.CompanyUserTO = CompanyUserTO;
;
//# sourceMappingURL=company.user.to.js.map