"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateMinimalToEditAgileTender = exports.MinimalToEditAgileTender = exports.AgileTender = exports.InsertAgileTender = void 0;
const swagger_1 = require("@nestjs/swagger");
const application_1 = require("../../application");
class AgileTender {
    constructor(id, code, name, description, details, createdAt, closeDate, isFavorite, descriptionLocation, amountCLP, updatedAt, subdivisionId) {
        this.descriptionLocation = descriptionLocation;
        this.code = code;
        this.name = name;
        this.updatedAt = updatedAt;
        this.closeDate = closeDate;
        this.description = description;
        this.id = id;
        this.details = details;
        this.createdAt = createdAt;
        this.isFavorite = isFavorite;
        this.subdivisionId = subdivisionId;
        this.amountCLP = amountCLP;
    }
}
exports.AgileTender = AgileTender;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender id',
        example: 1,
    }),
    __metadata("design:type", Number)
], AgileTender.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender code',
        example: '1111-111-A111',
    }),
    __metadata("design:type", String)
], AgileTender.prototype, "code", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender name',
        example: 'School supplies',
    }),
    __metadata("design:type", String)
], AgileTender.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender description',
        example: 'School supplies for the next school year',
    }),
    __metadata("design:type", String)
], AgileTender.prototype, "description", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender description location',
        example: 'Municipality of Santiago',
    }),
    __metadata("design:type", String)
], AgileTender.prototype, "descriptionLocation", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender details',
        type: application_1.AgileTenderFullInfoTO
    }),
    __metadata("design:type", application_1.AgileTenderFullInfoTO)
], AgileTender.prototype, "details", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Creation date',
        example: '1991-01-01T00:00:00.000Z',
        required: false,
    }),
    __metadata("design:type", Date)
], AgileTender.prototype, "createdAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Update date',
        example: '1991-01-01T00:00:00.000Z',
        required: false,
    }),
    __metadata("design:type", Object)
], AgileTender.prototype, "updatedAt", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Tender isFavorite',
        example: true,
    }),
    __metadata("design:type", Boolean)
], AgileTender.prototype, "isFavorite", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Close date',
        example: '1991-01-01T00:00:00.000Z',
        required: true,
    }),
    __metadata("design:type", Date)
], AgileTender.prototype, "closeDate", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'amount clp',
        example: 1545,
        type: Number,
        required: true,
    }),
    __metadata("design:type", Number)
], AgileTender.prototype, "amountCLP", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Subdivision id',
        example: 19,
        type: Number,
        required: false,
    }),
    __metadata("design:type", Object)
], AgileTender.prototype, "subdivisionId", void 0);
class InsertAgileTender extends (0, swagger_1.OmitType)(AgileTender, ['id']) {
}
exports.InsertAgileTender = InsertAgileTender;
class MinimalToEditAgileTender extends (0, swagger_1.OmitType)(AgileTender, [
    'code',
    'name',
    'createdAt',
    'updatedAt',
    'isFavorite',
    'closeDate',
    'amountCLP',
]) {
}
exports.MinimalToEditAgileTender = MinimalToEditAgileTender;
class UpdateMinimalToEditAgileTender extends (0, swagger_1.OmitType)(AgileTender, [
    'code',
    'name',
    'createdAt',
    'updatedAt',
    'isFavorite',
    'closeDate',
    'amountCLP',
    'details',
    'descriptionLocation'
]) {
}
exports.UpdateMinimalToEditAgileTender = UpdateMinimalToEditAgileTender;
//# sourceMappingURL=agile-tender.entity.js.map