"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateKeyword = exports.KeywordOrigin = exports.KeywordItem = exports.Keyword = exports.InsertKeyword = exports.AddCompanyKeyword = void 0;
const swagger_1 = require("@nestjs/swagger");
var KeywordOrigin;
(function (KeywordOrigin) {
    KeywordOrigin["USER"] = "USER";
    KeywordOrigin["MERCADO_PUBLICO"] = "MERCADO_PUBLICO";
    KeywordOrigin["ADMIN"] = "ADMIN";
})(KeywordOrigin || (exports.KeywordOrigin = KeywordOrigin = {}));
class Keyword {
    constructor(id, value, codeCategoriaMercadoPublico, origin, isSelected, metadata) {
        this.id = id;
        this.value = value;
        this.origin = origin;
        this.codeCategoriaMercadoPublico = codeCategoriaMercadoPublico;
        this.isSelected = isSelected;
        this.metadata = metadata;
    }
}
exports.Keyword = Keyword;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Keyword id',
        example: 1,
    }),
    __metadata("design:type", Number)
], Keyword.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Keyword name',
        example: 'Venta',
        required: false,
    }),
    __metadata("design:type", String)
], Keyword.prototype, "value", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Code Categoria Mercado Publico',
        example: 123,
        type: Number,
        required: true,
    }),
    __metadata("design:type", Number)
], Keyword.prototype, "codeCategoriaMercadoPublico", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Keyword origin',
        enum: KeywordOrigin,
        enumName: 'KeywordOrigin',
    }),
    __metadata("design:type", String)
], Keyword.prototype, "origin", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'State bool for favorites section',
        example: true,
        required: false,
    }),
    __metadata("design:type", Boolean)
], Keyword.prototype, "isSelected", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Metadata',
        required: false,
    }),
    __metadata("design:type", Object)
], Keyword.prototype, "metadata", void 0);
class InsertKeyword extends (0, swagger_1.OmitType)(Keyword, ['id', 'isSelected']) {
}
exports.InsertKeyword = InsertKeyword;
class AddCompanyKeyword extends (0, swagger_1.OmitType)(Keyword, [
    'id',
    'isSelected',
    'metadata',
]) {
}
exports.AddCompanyKeyword = AddCompanyKeyword;
class UpdateKeyword extends (0, swagger_1.PartialType)(InsertKeyword) {
}
exports.UpdateKeyword = UpdateKeyword;
class KeywordItem extends (0, swagger_1.OmitType)(Keyword, ['id', 'metadata']) {
}
exports.KeywordItem = KeywordItem;
//# sourceMappingURL=keyword.entity.js.map