"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateMatchingWord = exports.InsertMatchingWord = exports.MatchingWord = void 0;
const swagger_1 = require("@nestjs/swagger");
const application_1 = require("../../application");
const subdivision_entity_1 = require("../../../framework/domain/entities/subdivision.entity");
class MatchingWord {
    constructor(id, coincidence, subdivision, subdivisionId) {
        this.id = id;
        this.coincidence = coincidence;
        this.subdivision = subdivision;
        this.subdivisionId = subdivisionId;
    }
}
exports.MatchingWord = MatchingWord;
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Keyword id',
        example: 1,
    }),
    __metadata("design:type", Number)
], MatchingWord.prototype, "id", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Keyword name',
        required: true,
    }),
    __metadata("design:type", application_1.MatchWordTO)
], MatchingWord.prototype, "coincidence", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'User id',
        type: () => subdivision_entity_1.Subdivision,
    }),
    __metadata("design:type", Object)
], MatchingWord.prototype, "subdivision", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({
        description: 'Subdivision id',
        example: 1,
        type: Number,
        required: false,
    }),
    __metadata("design:type", Object)
], MatchingWord.prototype, "subdivisionId", void 0);
class InsertMatchingWord extends (0, swagger_1.OmitType)(MatchingWord, ['id', 'subdivision']) {
}
exports.InsertMatchingWord = InsertMatchingWord;
class UpdateMatchingWord extends (0, swagger_1.OmitType)(MatchingWord, ['subdivision']) {
}
exports.UpdateMatchingWord = UpdateMatchingWord;
//# sourceMappingURL=matching-word.entity.js.map