import { User } from 'src/framework';
import { AgileTenderFullInfoTO } from 'src/licitaapp/application';
import { TenderService } from 'src/licitaapp/application/service/tender-service/tender-service.interface';
import { UserCompanyAgileTenderService } from 'src/licitaapp/application/service/user-company-agile-tender-service/user-company-agile-tender-service.interface';
import { AgileTender, MinimalToEditAgileTender, UpdateMinimalToEditAgileTender } from 'src/licitaapp/domain';
import { PaginationAgileTenderTO } from 'src/licitaapp/domain/dto/pagination-agile-tender.to';
export declare class AgileTenderController {
    private readonly tenderService;
    private readonly userCompanyAgileTenderService;
    private readonly LOGGER;
    constructor(tenderService: TenderService, userCompanyAgileTenderService: UserCompanyAgileTenderService);
    adminPagination(page: number, pageSize: number, order: string, filter: string): Promise<PaginationAgileTenderTO[]>;
    findById(id: number): Promise<AgileTender | null | undefined>;
    findMinimalToEditById(id: number): Promise<MinimalToEditAgileTender | undefined>;
    paginationByUser(page: number, pageSize: number, typeSearch: string, companyId: number, user: User): Promise<AgileTenderFullInfoTO[]>;
    getTenderAgileHistoryPaginated(user: User, page: number, pageSize: number, companyId: number, searchType: string, isFavorite: string): Promise<AgileTenderFullInfoTO[]>;
    updateFavoriteUserCompanyAgiletender(user: User, agileTenderId: number, companyId: number, isFavorite: string, agileCode: string): Promise<String>;
    listFavoriteAgileTender(user: User): Promise<number[]>;
    updateMinimalAgileTender(dataAgiletender: UpdateMinimalToEditAgileTender): Promise<string>;
}
