"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var AgileTenderController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AgileTenderController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const framework_1 = require("../../../../framework");
const allow_roles_decorator_1 = require("../../../../framework/infrastructure/decorators/allow-profiles/allow-roles.decorator");
const api_default_responses_decorator_1 = require("../../../../framework/infrastructure/decorators/api-default-responses/api-default-responses.decorator");
const prime_user_decorator_1 = require("../../../../framework/infrastructure/decorators/prime-user/prime-user.decorator");
const application_1 = require("../../../application");
const domain_1 = require("../../../domain");
const pagination_agile_tender_to_1 = require("../../../domain/dto/pagination-agile-tender.to");
let AgileTenderController = AgileTenderController_1 = class AgileTenderController {
    constructor(tenderService, userCompanyAgileTenderService) {
        this.tenderService = tenderService;
        this.userCompanyAgileTenderService = userCompanyAgileTenderService;
        this.LOGGER = new framework_1.PrimeLogger(AgileTenderController_1.name);
    }
    async adminPagination(page, pageSize, order, filter) {
        this.LOGGER.warn(`Finding admin agile tenders page: ${page} pageSize: ${pageSize} order: ${order} filter: ${filter}`);
        return await this.tenderService.getAgileTenderAdminPaginated(page, pageSize, order, filter);
    }
    async findById(id) {
        this.LOGGER.log(`Finding agile tender by id: ${id}`);
        return await this.tenderService.getAgileTenderById(id);
    }
    async findMinimalToEditById(id) {
        this.LOGGER.log(`Finding agile tender by id: ${id}`);
        return await this.tenderService.getAgileTenderMinimalToEditById(id);
    }
    async paginationByUser(page, pageSize, typeSearch, companyId, user) {
        this.LOGGER.warn(`Finding agile tenders page: ${page} pageSize: ${pageSize} typeSearch: ${typeSearch} companyId: ${companyId}`);
        return await this.tenderService.getAgileTenderPaginated(page, pageSize, typeSearch, companyId, user.id);
    }
    async getTenderAgileHistoryPaginated(user, page, pageSize, companyId, searchType, isFavorite) {
        this.LOGGER.log(`GetTenderAgilePaginated - user: ${user.id}, page: ${page}, pageSize: ${pageSize}, companyId: ${companyId}, searchType: ${searchType} isFavorite: ${isFavorite}`);
        return await this.userCompanyAgileTenderService.getPaginatedAgileTenders(user.id, companyId, page, pageSize, isFavorite === 'true');
    }
    async updateFavoriteUserCompanyAgiletender(user, agileTenderId, companyId, isFavorite, agileCode) {
        this.LOGGER.log(`Favorite - user: ${user.id}, agileTenderId: ${agileTenderId}, isFavorite: ${isFavorite} companyId: ${companyId} agileCode: ${agileCode}`);
        await this.userCompanyAgileTenderService.saveAll(user.id, companyId, [agileTenderId], isFavorite === 'true', agileCode, this.tenderService.getUserRequestService());
        return 'true';
    }
    async listFavoriteAgileTender(user) {
        this.LOGGER.log(`ListFavoriteAgileTender - user: ${user.id}`);
        return await this.userCompanyAgileTenderService.getFavoriteList(user.id);
    }
    async updateMinimalAgileTender(dataAgiletender) {
        await this.tenderService.updateMinimalAgileTender(dataAgiletender);
        return 'true';
    }
};
exports.AgileTenderController = AgileTenderController;
__decorate([
    (0, common_1.Get)('admin-pagination/:page/:pageSize'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: [pagination_agile_tender_to_1.PaginationAgileTenderTO] }),
    (0, swagger_1.ApiParam)({ name: 'page', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'pageSize', type: 'number' }),
    (0, swagger_1.ApiQuery)({ name: 'order', type: 'string', required: false }),
    (0, swagger_1.ApiQuery)({ name: 'filter', type: 'string', required: false }),
    __param(0, (0, common_1.Param)('page')),
    __param(1, (0, common_1.Param)('pageSize')),
    __param(2, (0, common_1.Query)('order')),
    __param(3, (0, common_1.Query)('filter')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String, String]),
    __metadata("design:returntype", Promise)
], AgileTenderController.prototype, "adminPagination", null);
__decorate([
    (0, common_1.Get)('by-id/:id'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: domain_1.AgileTender }),
    (0, swagger_1.ApiParam)({ name: 'id', type: 'number' }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], AgileTenderController.prototype, "findById", null);
__decorate([
    (0, common_1.Get)('minimal-to-edit-by-id/:id'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: domain_1.MinimalToEditAgileTender }),
    (0, swagger_1.ApiParam)({ name: 'id', type: 'number' }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], AgileTenderController.prototype, "findMinimalToEditById", null);
__decorate([
    (0, common_1.Get)(':page/:pageSize/:typeSearch/:companyId'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER),
    (0, swagger_1.ApiOkResponse)({ type: [application_1.AgileTenderFullInfoTO] }),
    (0, swagger_1.ApiParam)({ name: 'page', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'pageSize', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'typeSearch', type: 'string' }),
    (0, swagger_1.ApiParam)({ name: 'companyId', type: 'number' }),
    __param(0, (0, common_1.Param)('page')),
    __param(1, (0, common_1.Param)('pageSize')),
    __param(2, (0, common_1.Param)('typeSearch')),
    __param(3, (0, common_1.Param)('companyId')),
    __param(4, (0, prime_user_decorator_1.PrimeUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String, Number, framework_1.User]),
    __metadata("design:returntype", Promise)
], AgileTenderController.prototype, "paginationByUser", null);
__decorate([
    (0, common_1.Get)('history-agile/:page/:pageSize/:companyId/:searchType/:isFavorite'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: [application_1.AgileTenderFullInfoTO] }),
    (0, swagger_1.ApiParam)({ name: 'page', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'pageSize', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'companyId', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'searchType', type: 'string' }),
    (0, swagger_1.ApiParam)({ name: 'isFavorite', type: 'string' }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Param)('page')),
    __param(2, (0, common_1.Param)('pageSize')),
    __param(3, (0, common_1.Param)('companyId')),
    __param(4, (0, common_1.Param)('searchType')),
    __param(5, (0, common_1.Param)('isFavorite')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User, Number, Number, Number, String, String]),
    __metadata("design:returntype", Promise)
], AgileTenderController.prototype, "getTenderAgileHistoryPaginated", null);
__decorate([
    (0, common_1.Put)('update-favorite-user-agile-tender/:agileTenderId/:companyId/:isFavorite/:agileCode'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: () => String }),
    (0, swagger_1.ApiParam)({ name: 'agileTenderId', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'isFavorite', type: 'string' }),
    (0, swagger_1.ApiParam)({ name: 'companyId', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'agileCode', type: 'string' }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Param)('agileTenderId')),
    __param(2, (0, common_1.Param)('companyId')),
    __param(3, (0, common_1.Param)('isFavorite')),
    __param(4, (0, common_1.Param)('agileCode')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User, Number, Number, String, String]),
    __metadata("design:returntype", Promise)
], AgileTenderController.prototype, "updateFavoriteUserCompanyAgiletender", null);
__decorate([
    (0, common_1.Get)('favorites'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: [Number] }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User]),
    __metadata("design:returntype", Promise)
], AgileTenderController.prototype, "listFavoriteAgileTender", null);
__decorate([
    (0, common_1.Put)('update-data-minimal-to-edit'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    (0, swagger_1.ApiBody)({ type: domain_1.UpdateMinimalToEditAgileTender }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.UpdateMinimalToEditAgileTender]),
    __metadata("design:returntype", Promise)
], AgileTenderController.prototype, "updateMinimalAgileTender", null);
exports.AgileTenderController = AgileTenderController = AgileTenderController_1 = __decorate([
    (0, common_1.Controller)('agile-tender'),
    (0, swagger_1.ApiTags)('agile-tender'),
    __param(0, (0, common_1.Inject)('TenderService')),
    __param(1, (0, common_1.Inject)('UserCompanyAgileTenderService')),
    __metadata("design:paramtypes", [Object, Object])
], AgileTenderController);
//# sourceMappingURL=agile-tender.controller.js.map