"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var ApplicationLogController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationLogController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const framework_1 = require("../../../../framework");
const allow_roles_decorator_1 = require("../../../../framework/infrastructure/decorators/allow-profiles/allow-roles.decorator");
const api_default_responses_decorator_1 = require("../../../../framework/infrastructure/decorators/api-default-responses/api-default-responses.decorator");
const domain_1 = require("../../../domain");
const enum_definition_1 = require("../../../domain/enum/enum.definition");
let ApplicationLogController = ApplicationLogController_1 = class ApplicationLogController {
    constructor(applicationLogService) {
        this.applicationLogService = applicationLogService;
        this.LOGGER = new framework_1.PrimeLogger(ApplicationLogController_1.name);
    }
    async findAll(page, pageSize, type) {
        this.LOGGER.log(`Finding all application logs with page: ${page}, pageSize: ${pageSize}, type: ${type}`);
        return await this.applicationLogService.getAllPaginated(page, pageSize, type);
    }
    async logicalRemove(applicationId) {
        this.LOGGER.warn(`delete application-log by applicationId: ${applicationId}`);
        await this.applicationLogService.logicalRemove(applicationId);
        return 'true';
    }
};
exports.ApplicationLogController = ApplicationLogController;
__decorate([
    (0, common_1.Get)(':page/:pageSize'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.ADMIN, allow_roles_decorator_1.RoleShortNameEnum.USER),
    (0, swagger_1.ApiOkResponse)({ type: [domain_1.ApplicationLog] }),
    (0, swagger_1.ApiParam)({ name: 'page', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'pageSize', type: 'number' }),
    (0, swagger_1.ApiQuery)({ name: 'type', enum: enum_definition_1.ApplicationTypeEnum, required: false }),
    __param(0, (0, common_1.Param)('page')),
    __param(1, (0, common_1.Param)('pageSize')),
    __param(2, (0, common_1.Query)('type')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number, String]),
    __metadata("design:returntype", Promise)
], ApplicationLogController.prototype, "findAll", null);
__decorate([
    (0, common_1.Delete)('/:applicationId'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    __param(0, (0, common_1.Param)('applicationId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], ApplicationLogController.prototype, "logicalRemove", null);
exports.ApplicationLogController = ApplicationLogController = ApplicationLogController_1 = __decorate([
    (0, common_1.Controller)('application-log'),
    (0, swagger_1.ApiTags)('application-log'),
    __param(0, (0, common_1.Inject)('ApplicationLogService')),
    __metadata("design:paramtypes", [Object])
], ApplicationLogController);
//# sourceMappingURL=application-log.controller.js.map