import { User } from 'src/framework';
import { CompanyService, KeywordService, UserCompanyService } from 'src/licitaapp';
import { CompanyKeywordService } from 'src/licitaapp/application/service/company-keyword-service/company-keyword-service.interface';
import { TenderService } from 'src/licitaapp/application/service/tender-service/tender-service.interface';
import { Company, CompanyFullTO, CompanyRegisterTO } from 'src/licitaapp/domain';
import { PaginationKeywordTO } from 'src/licitaapp/domain/dto/company.user.to';
import { UserPaginationTO } from 'src/licitaapp/domain/dto/user.pagination.to';
export declare class CompanyController {
    private readonly companyService;
    private readonly userCompanyService;
    private readonly tenderService;
    private readonly companyKeywordService;
    private readonly keywordService;
    private readonly LOGGER;
    constructor(companyService: CompanyService, userCompanyService: UserCompanyService, tenderService: TenderService, companyKeywordService: CompanyKeywordService, keywordService: KeywordService);
    companiesByUserId(user: User): Promise<Company[]>;
    activeCheckTender(id: number): Promise<String>;
    update(user: User, id: number, companyData: CompanyRegisterTO): Promise<CompanyFullTO | null>;
    logicalRemoveKeyword(user: User, codeCategoriaMercadoPublico: number, companyId: number): Promise<String>;
    findById(id: number): Promise<CompanyFullTO | null>;
    paginationByUser(user: User, page: number, pageSize: number): Promise<Company[]>;
    findByUserId(user: User): Promise<Company[]>;
    logicalRemove(user: User, companyId: number, userId: number): Promise<String>;
    paginationCompanyAdmin(page: number, pageSize: number): Promise<UserPaginationTO>;
    paginationCompanyKeyword(page: number, pageSize: number, socialReason?: string): Promise<PaginationKeywordTO[]>;
}
