"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var GeneralActionTenderController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneralActionTenderController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const framework_1 = require("../../../../framework");
const allow_roles_decorator_1 = require("../../../../framework/infrastructure/decorators/allow-profiles/allow-roles.decorator");
const api_default_responses_decorator_1 = require("../../../../framework/infrastructure/decorators/api-default-responses/api-default-responses.decorator");
const domain_1 = require("../../../domain");
let GeneralActionTenderController = GeneralActionTenderController_1 = class GeneralActionTenderController {
    constructor(tenderService, userCompanyService) {
        this.tenderService = tenderService;
        this.userCompanyService = userCompanyService;
        this.LOGGER = new framework_1.PrimeLogger(GeneralActionTenderController_1.name);
    }
    async update(companyId) {
        this.LOGGER.warn(`Updating company ${companyId} dashboard`);
        const infoUsers = await this.userCompanyService.getInfoUserCompany(companyId);
        this.tenderService.createDashboardCompany(companyId, infoUsers.map((i) => i.userId));
        return 'Generación solicitada correctamente';
    }
    async sendNotificationAdmin() {
        this.LOGGER.warn(`sendNotificationAdmin`);
        this.tenderService.getFirebaseService().notifyToAdminUsers(0);
    }
    async generalInfoData() {
        this.LOGGER.warn(`generalInfoData`);
        return await this.tenderService.createGeneralDataQuery();
    }
};
exports.GeneralActionTenderController = GeneralActionTenderController;
__decorate([
    (0, common_1.Put)(':companyId'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOperation)({
        summary: 'En base a un ID de empresa, regenera para todos sus usuarios el dashboard (Union de licitaciones a usuario.).',
    }),
    (0, swagger_1.ApiOkResponse)({
        description: 'Gatilla el proceso de dashboard empresa',
        type: () => String,
    }),
    (0, swagger_1.ApiParam)({ name: 'companyId', type: 'number' }),
    __param(0, (0, common_1.Param)('companyId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], GeneralActionTenderController.prototype, "update", null);
__decorate([
    (0, common_1.Post)('send-notification-admin'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], GeneralActionTenderController.prototype, "sendNotificationAdmin", null);
__decorate([
    (0, common_1.Get)('general-info-data'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: domain_1.GeneralDataInfoTO }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], GeneralActionTenderController.prototype, "generalInfoData", null);
exports.GeneralActionTenderController = GeneralActionTenderController = GeneralActionTenderController_1 = __decorate([
    (0, common_1.Controller)('general-action-tender'),
    (0, swagger_1.ApiTags)('general-action-tender'),
    __param(0, (0, common_1.Inject)('TenderService')),
    __param(1, (0, common_1.Inject)('UserCompanyService')),
    __metadata("design:paramtypes", [Object, Object])
], GeneralActionTenderController);
//# sourceMappingURL=general-action-tender.controller.js.map