"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var KeywordController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeywordController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const framework_1 = require("../../../../framework");
const allow_roles_decorator_1 = require("../../../../framework/infrastructure/decorators/allow-profiles/allow-roles.decorator");
const api_default_responses_decorator_1 = require("../../../../framework/infrastructure/decorators/api-default-responses/api-default-responses.decorator");
const domain_1 = require("../../../domain");
let KeywordController = KeywordController_1 = class KeywordController {
    constructor(keywordService, companyKeywordService) {
        this.keywordService = keywordService;
        this.companyKeywordService = companyKeywordService;
        this.LOGGER = new framework_1.PrimeLogger(KeywordController_1.name);
    }
    async findAdminValues() {
        this.LOGGER.log(`findAdminValues`);
        return await this.keywordService.findAdminValues();
    }
    async findAllByName(search) {
        return this.keywordService.findByName(search);
    }
    async findByCompanyId(companyId) {
        return this.companyKeywordService.findByCompanyId(companyId);
    }
    async logicalRemove(keywordId, companyId) {
        this.LOGGER.log(`logicalRemove keyword: ${keywordId} to company: ${companyId}`);
        await this.companyKeywordService.deleteByCompanyAndKeywordId(companyId, keywordId);
        return 'true';
    }
    async createKeyword(data) {
        this.LOGGER.warn(`createKeyword keyword: ${JSON.stringify(data)}`);
        await this.keywordService.save(data);
        return 'true';
    }
};
exports.KeywordController = KeywordController;
__decorate([
    (0, common_1.Get)('find-admin-values'),
    (0, swagger_1.ApiOkResponse)({ type: [String] }),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], KeywordController.prototype, "findAdminValues", null);
__decorate([
    (0, common_1.Get)(':search'),
    (0, swagger_1.ApiOkResponse)({ type: [domain_1.KeywordItem] }),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiParam)({ name: 'search', type: 'string' }),
    __param(0, (0, common_1.Param)('search')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], KeywordController.prototype, "findAllByName", null);
__decorate([
    (0, common_1.Get)('find-by-company/:companyId'),
    (0, swagger_1.ApiOkResponse)({ type: [domain_1.Keyword] }),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiParam)({ name: 'companyId', type: 'number' }),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    __param(0, (0, common_1.Param)('companyId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], KeywordController.prototype, "findByCompanyId", null);
__decorate([
    (0, common_1.Delete)('errase-keyword-to-company/:keywordId/:companyId'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER),
    (0, swagger_1.ApiParam)({ name: 'keywordId', type: 'number', required: true }),
    (0, swagger_1.ApiParam)({ name: 'companyId', type: 'number', required: true }),
    __param(0, (0, common_1.Param)('keywordId')),
    __param(1, (0, common_1.Param)('companyId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], KeywordController.prototype, "logicalRemove", null);
__decorate([
    (0, common_1.Post)(),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiBody)({ type: domain_1.InsertKeyword }),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.InsertKeyword]),
    __metadata("design:returntype", Promise)
], KeywordController.prototype, "createKeyword", null);
exports.KeywordController = KeywordController = KeywordController_1 = __decorate([
    (0, common_1.Controller)('keyword'),
    (0, swagger_1.ApiTags)('keyword'),
    __param(0, (0, common_1.Inject)('KeywordService')),
    __param(1, (0, common_1.Inject)('CompanyKeywordService')),
    __metadata("design:paramtypes", [Object, Object])
], KeywordController);
//# sourceMappingURL=keyword.controller.js.map